/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.client.gui;

import com.structurize.blockout.Log;
import com.structurize.blockout.Pane;
import com.structurize.blockout.controls.ButtonImage;
import com.structurize.blockout.controls.TextField;
import com.structurize.blockout.views.View;
import com.structurize.coremod.Structurize;
import com.structurize.coremod.client.gui.AbstractWindowSkeleton;
import com.structurize.coremod.network.messages.MultiBlockChangeMessage;
import com.structurize.coremod.tileentities.TileEntityMultiBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.Nullable;

public class WindowMultiBlock
extends AbstractWindowSkeleton {
    private static final String RES_STRING = "textures/gui/buildtool/%s.png";
    private static final String GREEN_POS = "_green";
    private static final String RED_POS = "_red";
    private final BlockPos pos;
    private EnumFacing facing = EnumFacing.UP;
    private EnumFacing output = EnumFacing.DOWN;
    private final TextField inputRange;
    private final TextField inputSpeed;

    public WindowMultiBlock(@Nullable BlockPos pos) {
        super("structurize:gui/windowmultiblock.xml");
        this.pos = pos;
        this.inputRange = this.findPaneOfTypeByID("range", TextField.class);
        this.inputSpeed = this.findPaneOfTypeByID("speed", TextField.class);
        this.init();
    }

    private void init() {
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("plus", this::moveUpClicked);
        this.registerButton("minus", this::moveDownClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
    }

    @Override
    public void onOpened() {
        TileEntity block = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
        if (block instanceof TileEntityMultiBlock) {
            this.inputRange.setText(Integer.toString(((TileEntityMultiBlock)block).getRange()));
            this.inputSpeed.setText(Integer.toString(((TileEntityMultiBlock)block).getSpeed()));
            EnumFacing dir = ((TileEntityMultiBlock)block).getDirection();
            EnumFacing out = ((TileEntityMultiBlock)block).getOutput();
            this.enable(dir, dir, false);
            this.enable(out, out, true);
            return;
        }
        this.close();
    }

    private void enable(EnumFacing oldFacing, EnumFacing newFacing, boolean rightClick) {
        switch (oldFacing) {
            case DOWN: {
                this.findPaneOfTypeByID("minus", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "minus")));
                break;
            }
            case NORTH: {
                this.findPaneOfTypeByID("up", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "up")));
                break;
            }
            case SOUTH: {
                this.findPaneOfTypeByID("down", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "down")));
                break;
            }
            case EAST: {
                this.findPaneOfTypeByID("right", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "right")));
                break;
            }
            case WEST: {
                this.findPaneOfTypeByID("left", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "left")));
                break;
            }
            default: {
                this.findPaneOfTypeByID("plus", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "plus")));
            }
        }
        String color = rightClick ? RED_POS : GREEN_POS;
        switch (newFacing) {
            case DOWN: {
                this.findPaneOfTypeByID("minus", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "minus" + color)));
                break;
            }
            case NORTH: {
                this.findPaneOfTypeByID("up", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "up" + color)));
                break;
            }
            case SOUTH: {
                this.findPaneOfTypeByID("down", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "down" + color)));
                break;
            }
            case EAST: {
                this.findPaneOfTypeByID("right", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "right" + color)));
                break;
            }
            case WEST: {
                this.findPaneOfTypeByID("left", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "left" + color)));
                break;
            }
            default: {
                this.findPaneOfTypeByID("plus", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "plus" + color)));
            }
        }
        if (rightClick) {
            this.output = newFacing;
        } else {
            this.facing = newFacing;
        }
    }

    private void moveUpClicked() {
        this.enable(this.facing, EnumFacing.UP, false);
    }

    private void moveDownClicked() {
        this.enable(this.facing, EnumFacing.DOWN, false);
    }

    private void moveLeftClicked() {
        this.enable(this.facing, EnumFacing.WEST, false);
    }

    private void moveForwardClicked() {
        this.enable(this.facing, EnumFacing.NORTH, false);
    }

    private void moveBackClicked() {
        this.enable(this.facing, EnumFacing.SOUTH, false);
    }

    private void moveRightClicked() {
        this.enable(this.facing, EnumFacing.EAST, false);
    }

    private void confirmClicked() {
        int range = 3;
        int speed = 2;
        try {
            range = Integer.valueOf(this.inputRange.getText());
            speed = Integer.valueOf(this.inputSpeed.getText());
        }
        catch (NumberFormatException e) {
            Log.getLogger().warn("Unable to parse number for MultiBlock range or speed, considering default range/speed!", (Throwable)e);
        }
        Structurize.getNetwork().sendToServer((IMessage)new MultiBlockChangeMessage(this.pos, this.facing, this.output, range, speed));
        this.close();
    }

    @Override
    public void rightClick(int mx, int my) {
        Pane pane = this.findPaneForClick(mx, my);
        if (pane instanceof View) {
            pane = ((View)pane).findPaneForClick(mx - pane.getX(), my - pane.getY());
        }
        if (pane instanceof ButtonImage && pane.isEnabled()) {
            EnumFacing newFacing;
            switch (pane.getID()) {
                case "plus": {
                    newFacing = EnumFacing.UP;
                    break;
                }
                case "minus": {
                    newFacing = EnumFacing.DOWN;
                    break;
                }
                case "up": {
                    newFacing = EnumFacing.NORTH;
                    break;
                }
                case "down": {
                    newFacing = EnumFacing.SOUTH;
                    break;
                }
                case "right": {
                    newFacing = EnumFacing.EAST;
                    break;
                }
                case "left": {
                    newFacing = EnumFacing.WEST;
                    break;
                }
                default: {
                    newFacing = EnumFacing.UP;
                }
            }
            this.enable(this.output, newFacing, true);
        }
    }

    private void cancelClicked() {
        this.close();
    }
}

