/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.client.gui;

import com.structurize.api.util.BlockUtils;
import com.structurize.api.util.LanguageHandler;
import com.structurize.blockout.Log;
import com.structurize.blockout.controls.Button;
import com.structurize.blockout.views.DropDownList;
import com.structurize.coremod.Structurize;
import com.structurize.coremod.client.gui.AbstractWindowSkeleton;
import com.structurize.coremod.client.gui.DialogDoneCancel;
import com.structurize.coremod.client.gui.WindowStructureNameEntry;
import com.structurize.coremod.management.Manager;
import com.structurize.coremod.management.StructureName;
import com.structurize.coremod.management.Structures;
import com.structurize.coremod.network.messages.BuildToolPasteMessage;
import com.structurize.coremod.network.messages.SchematicRequestMessage;
import com.structurize.coremod.network.messages.SchematicSaveMessage;
import com.structurize.structures.helpers.Settings;
import com.structurize.structures.helpers.Structure;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scala.Array;

public class WindowBuildTool
extends AbstractWindowSkeleton {
    private static final int POSSIBLE_ROTATIONS = 4;
    private static final int ROTATE_RIGHT = 1;
    private static final int ROTATE_180 = 2;
    private static final int ROTATE_LEFT = 3;
    private static final String BUTTON_PASTE = "pastecomplete";
    private static final String BUTTON_PASTE_NICE = "pastenice";
    @NotNull
    private final List<String> sections = new ArrayList<String>();
    @NotNull
    private List<String> styles = new ArrayList<String>();
    @NotNull
    private List<String> schematics = new ArrayList<String>();
    @NotNull
    private BlockPos pos = new BlockPos(0, 0, 0);
    private int rotation = 0;
    private DropDownList sectionsDropDownList;
    private DropDownList stylesDropDownList;
    private DropDownList schematicsDropDownList;
    private Button renameButton;
    private Button deleteButton;
    private DialogDoneCancel confirmDeleteDialog;
    private String staticSchematicName = "";

    public WindowBuildTool(@Nullable BlockPos pos, String structureName, int rotation, FreeMode mode) {
        super("structurize:gui/windowbuildtool.xml");
        if (!this.hasPermission()) {
            return;
        }
        this.init(pos);
        if (pos != null) {
            Settings.instance.setupStaticMode(structureName, mode);
            this.staticSchematicName = structureName;
            Settings.instance.setRotation(rotation);
            this.rotation = rotation;
        }
        this.renameButton = this.findPaneOfTypeByID("rename", Button.class);
        this.deleteButton = this.findPaneOfTypeByID("delete", Button.class);
    }

    public WindowBuildTool(@Nullable BlockPos pos) {
        super("structurize:gui/windowbuildtool.xml");
        if (!this.hasPermission()) {
            return;
        }
        this.init(pos);
        this.renameButton = this.findPaneOfTypeByID("rename", Button.class);
        this.deleteButton = this.findPaneOfTypeByID("delete", Button.class);
    }

    private void init(BlockPos pos) {
        Structure structure = Settings.instance.getActiveStructure();
        if (structure != null) {
            this.rotation = Settings.instance.getRotation();
        } else if (pos != null) {
            this.pos = pos;
            Settings.instance.setPosition(pos);
            Settings.instance.setRotation(0);
        }
        this.initBuildingTypeNavigation();
        this.initStyleNavigation();
        this.initSchematicNavigation();
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("mirror", WindowBuildTool::mirror);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
        this.registerButton("plus", WindowBuildTool::moveUpClicked);
        this.registerButton("minus", WindowBuildTool::moveDownClicked);
        this.registerButton("rotateRight", this::rotateRightClicked);
        this.registerButton("rotateLeft", this::rotateLeftClicked);
        this.registerButton(BUTTON_PASTE, this::pasteComplete);
        this.registerButton(BUTTON_PASTE_NICE, this::pasteNice);
        this.registerButton("rename", this::renameClicked);
        this.registerButton("delete", this::deleteClicked);
    }

    public void pasteNice() {
        this.paste(false);
    }

    private void pasteComplete() {
        this.paste(true);
    }

    private void paste(boolean complete) {
        String sname = Settings.instance.isStaticSchematicMode() ? Settings.instance.getStaticSchematicName() : this.schematics.get(this.schematicsDropDownList.getSelectedIndex());
        StructureName structureName = new StructureName(sname);
        if (structureName.getPrefix().equals("scans") && FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            this.requestAndPlaceScannedSchematic(structureName, true, complete);
        } else {
            this.paste(structureName, complete);
        }
        Settings.instance.reset();
        this.close();
    }

    public String getSectionName(String name) {
        return name;
    }

    private void initBuildingTypeNavigation() {
        this.registerButton("previousBuildingType", this::previousSection);
        this.registerButton("nextBuildingType", this::nextSection);
        this.sectionsDropDownList = this.findPaneOfTypeByID("buildingType", DropDownList.class);
        this.sectionsDropDownList.setHandler(this::onDropDownListChanged);
        this.sectionsDropDownList.setDataProvider(new SectionDropDownList());
    }

    private void initStyleNavigation() {
        this.registerButton("previousStyle", this::previousStyle);
        this.registerButton("nextStyle", this::nextStyle);
        this.stylesDropDownList = this.findPaneOfTypeByID("style", DropDownList.class);
        this.stylesDropDownList.setHandler(this::onDropDownListChanged);
        this.stylesDropDownList.setDataProvider(new DropDownList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowBuildTool.this.styles.size();
            }

            @Override
            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildTool.this.styles.size()) {
                    return (String)WindowBuildTool.this.styles.get(index);
                }
                return "";
            }
        });
    }

    private void initSchematicNavigation() {
        this.registerButton("previousSchematic", this::previousSchematic);
        this.registerButton("nextSchematic", this::nextSchematic);
        this.schematicsDropDownList = this.findPaneOfTypeByID("schematic", DropDownList.class);
        this.schematicsDropDownList.setHandler(this::onDropDownListChanged);
        this.schematicsDropDownList.setDataProvider(new DropDownList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowBuildTool.this.schematics.size();
            }

            @Override
            public String getLabel(int index) {
                StructureName sn = new StructureName((String)WindowBuildTool.this.schematics.get(index));
                return sn.getLocalizedName();
            }
        });
    }

    private static void mirror() {
        Settings.instance.mirror();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (!this.hasPermission()) {
            this.close();
            return;
        }
        if (Settings.instance.isStaticSchematicMode()) {
            this.sections.add("schematics");
            this.setStructureName(this.staticSchematicName);
        } else {
            Structures.loadScannedStyleMaps();
            this.sections.clear();
            InventoryPlayer inventory = this.mc.field_71439_g.field_71071_by;
            List<String> allSections = Structures.getSections();
            for (String section : allSections) {
                if (!section.equals("schematics") && !section.equals("scans") && !WindowBuildTool.inventoryHasHut(inventory, section)) continue;
                this.sections.add(section);
            }
            if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                this.findPaneOfTypeByID(BUTTON_PASTE, Button.class).setVisible(true);
                this.findPaneOfTypeByID(BUTTON_PASTE_NICE, Button.class).setVisible(true);
            } else {
                this.findPaneOfTypeByID(BUTTON_PASTE, Button.class).setVisible(false);
                this.findPaneOfTypeByID(BUTTON_PASTE_NICE, Button.class).setVisible(false);
            }
            this.setStructureName(Settings.instance.getStructureName());
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (Manager.isSchematicDownloaded()) {
            Manager.setSchematicDownloaded(false);
            this.changeSchematic();
        }
    }

    @Override
    public void onClosed() {
        if (Settings.instance.getActiveStructure() != null) {
            Settings.instance.setSchematicInfo(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()), this.rotation);
        }
    }

    private void nextSection() {
        this.sectionsDropDownList.selectNext();
    }

    private void previousSection() {
        this.sectionsDropDownList.selectPrevious();
    }

    private void nextStyle() {
        this.stylesDropDownList.selectNext();
    }

    private void previousStyle() {
        this.stylesDropDownList.selectPrevious();
    }

    private void updateStyles() {
        String currentStyle = "";
        if (this.stylesDropDownList.getSelectedIndex() > -1 && this.stylesDropDownList.getSelectedIndex() < this.styles.size()) {
            currentStyle = this.styles.get(this.stylesDropDownList.getSelectedIndex());
        }
        this.styles = Structures.getStylesFor(this.sections.get(this.sectionsDropDownList.getSelectedIndex()));
        int newIndex = this.styles.indexOf(currentStyle);
        if (newIndex == -1) {
            newIndex = 0;
        }
        boolean enabled = Settings.instance.isStaticSchematicMode() ? false : this.styles.size() > 1;
        this.findPaneOfTypeByID("previousStyle", Button.class).setEnabled(enabled);
        this.findPaneOfTypeByID("style", DropDownList.class).setEnabled(enabled);
        this.findPaneOfTypeByID("nextStyle", Button.class).setEnabled(enabled);
        this.stylesDropDownList.setSelectedIndex(newIndex);
    }

    private void nextSchematic() {
        this.schematicsDropDownList.selectNext();
    }

    private void previousSchematic() {
        this.schematicsDropDownList.selectPrevious();
    }

    private void updateSchematics() {
        String schematic = "";
        if (this.schematicsDropDownList.getSelectedIndex() > -1 && this.schematicsDropDownList.getSelectedIndex() < this.schematics.size()) {
            schematic = this.schematics.get(this.schematicsDropDownList.getSelectedIndex());
        }
        String currentSchematic = schematic.isEmpty() ? "" : new StructureName(schematic).getSchematic();
        String section = this.sections.get(this.sectionsDropDownList.getSelectedIndex());
        String style = this.styles.get(this.stylesDropDownList.getSelectedIndex());
        if (Settings.instance.isStaticSchematicMode()) {
            this.schematics = new ArrayList<String>();
            this.schematics.add(this.staticSchematicName);
        } else {
            this.schematics = Structures.getSchematicsFor(section, style);
        }
        int newIndex = -1;
        for (int i = 0; i < this.schematics.size(); ++i) {
            StructureName sn = new StructureName(this.schematics.get(i));
            if (!sn.getSchematic().equals(currentSchematic)) continue;
            newIndex = i;
            break;
        }
        if (newIndex == -1) {
            newIndex = 0;
        }
        boolean enabled = Settings.instance.isStaticSchematicMode() ? false : this.schematics.size() > 1;
        this.findPaneOfTypeByID("previousSchematic", Button.class).setEnabled(enabled);
        this.findPaneOfTypeByID("schematic", DropDownList.class).setEnabled(enabled);
        this.findPaneOfTypeByID("nextSchematic", Button.class).setEnabled(enabled);
        this.schematicsDropDownList.setSelectedIndex(newIndex);
    }

    private void onDropDownListChanged(DropDownList list) {
        if (list.isEnabled()) {
            if (list == this.sectionsDropDownList) {
                String name = this.sections.get(this.sectionsDropDownList.getSelectedIndex());
                if ("scans".equals(name)) {
                    this.renameButton.setVisible(true);
                    this.deleteButton.setVisible(true);
                } else {
                    this.renameButton.setVisible(false);
                    this.deleteButton.setVisible(false);
                }
                this.updateStyles();
            } else if (list == this.stylesDropDownList) {
                this.updateSchematics();
            } else if (list == this.schematicsDropDownList) {
                this.changeSchematic();
            }
        }
    }

    private void setStructureName(String structureName) {
        StructureName sn;
        int sectionIndex;
        if (structureName != null && (sectionIndex = this.sections.indexOf((sn = new StructureName(structureName)).getSection())) != -1) {
            this.sectionsDropDownList.setSelectedIndex(sectionIndex);
            int styleIndex = this.styles.indexOf(sn.getStyle());
            if (styleIndex != -1) {
                this.stylesDropDownList.setSelectedIndex(styleIndex);
                int schematicIndex = this.schematics.indexOf(sn.toString());
                if (schematicIndex != -1) {
                    this.schematicsDropDownList.setSelectedIndex(schematicIndex);
                    return;
                }
            }
        }
        this.sectionsDropDownList.setSelectedIndex(0);
        this.stylesDropDownList.setSelectedIndex(0);
        this.schematicsDropDownList.setSelectedIndex(0);
    }

    private static boolean inventoryHasHut(@NotNull InventoryPlayer inventory, String hut) {
        return inventory.func_70431_c(new ItemStack(Block.func_149684_b((String)("minecolonies:blockHut" + hut))));
    }

    private static void moveUpClicked() {
        Settings.instance.moveTo(new BlockPos(0, 1, 0));
    }

    private static void moveDownClicked() {
        Settings.instance.moveTo(new BlockPos(0, -1, 0));
    }

    private void moveLeftClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176735_f()));
    }

    private void moveRightClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176746_e()));
    }

    private void moveForwardClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO()));
    }

    private void moveBackClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176734_d()));
    }

    private void rotateRightClicked() {
        this.rotation = (this.rotation + 1) % 4;
        WindowBuildTool.updateRotation(this.rotation);
    }

    private void rotateLeftClicked() {
        this.rotation = (this.rotation + 3) % 4;
        WindowBuildTool.updateRotation(this.rotation);
    }

    private void changeSchematic() {
        String sname = Settings.instance.isStaticSchematicMode() ? Settings.instance.getStaticSchematicName() : this.schematics.get(this.schematicsDropDownList.getSelectedIndex());
        StructureName structureName = new StructureName(sname);
        Structure structure = new Structure(null, structureName.toString(), new PlacementSettings().func_186220_a(BlockUtils.getRotation(Settings.instance.getRotation())).func_186214_a(Settings.instance.getMirror()));
        String md5 = Structures.getMD5(structureName.toString());
        if (structure.isTemplateMissing() || !structure.isCorrectMD5(md5)) {
            if (structure.isTemplateMissing()) {
                Log.getLogger().info("Template structure " + structureName + " missing");
            } else {
                Log.getLogger().info("structure " + structureName + " md5 error");
            }
            Log.getLogger().info("Request To Server for structure " + structureName);
            if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
                Structurize.getNetwork().sendToServer((IMessage)new SchematicRequestMessage(structureName.toString()));
                return;
            }
            Log.getLogger().error("WindowBuildTool: Need to download schematic on a standalone client/server. This should never happen");
        }
        Settings.instance.setStructureName(structureName.toString());
        Settings.instance.setActiveSchematic(structure);
        if (Settings.instance.getPosition() == null) {
            Settings.instance.setPosition(this.pos);
        }
    }

    public void requestAndPlaceScannedSchematic(@NotNull StructureName structureName, boolean paste, boolean complete) {
        if (!Structures.isPlayerSchematicsAllowed()) {
            return;
        }
        if (Structures.hasMD5(structureName)) {
            String md5 = Structures.getMD5(structureName.toString());
            String serverSideName = "cache/" + md5;
            if (!Structures.hasMD5(new StructureName(serverSideName))) {
                InputStream stream = Structure.getStream(structureName.toString());
                if (stream != null) {
                    UUID id = UUID.randomUUID();
                    byte[] structureAsByteArray = Structure.getStreamAsByteArray(stream);
                    if (structureAsByteArray.length <= 30000) {
                        Structurize.getNetwork().sendToServer((IMessage)new SchematicSaveMessage(structureAsByteArray, id, 1, 1));
                    } else {
                        int pieces = structureAsByteArray.length / 30000;
                        Log.getLogger().info("BuilderTool: sending: " + pieces + " pieces with the schematic " + structureName + "(md5:" + md5 + ") to the server");
                        for (int i = 1; i <= pieces; ++i) {
                            int start = (i - 1) * 30000;
                            int size = i == pieces ? structureAsByteArray.length - start : 30000;
                            byte[] bytes = new byte[size];
                            Array.copy((Object)structureAsByteArray, (int)start, (Object)bytes, (int)0, (int)size);
                            Structurize.getNetwork().sendToServer((IMessage)new SchematicSaveMessage(bytes, id, pieces, i));
                        }
                    }
                } else {
                    Log.getLogger().warn("BuilderTool: Can not load " + structureName);
                }
            } else {
                Log.getLogger().warn("BuilderTool: server does not have " + serverSideName);
            }
            if (paste) {
                Structurize.getNetwork().sendToServer((IMessage)new BuildToolPasteMessage(serverSideName, structureName.toString(), Settings.instance.getPosition(), Settings.instance.getRotation(), false, Settings.instance.getMirror(), complete, null));
            } else {
                this.place(new StructureName(serverSideName));
            }
        } else {
            Log.getLogger().warn("BuilderTool: Can not send schematic without md5: " + structureName);
        }
    }

    public static void requestScannedSchematic(@NotNull StructureName structureName) {
        if (!Structures.isPlayerSchematicsAllowed()) {
            return;
        }
        if (Structures.hasMD5(structureName)) {
            String md5 = Structures.getMD5(structureName.toString());
            String serverSideName = "cache/" + md5;
            if (!Structures.hasMD5(new StructureName(serverSideName))) {
                InputStream stream = Structure.getStream(structureName.toString());
                if (stream != null) {
                    UUID id = UUID.randomUUID();
                    byte[] structureAsByteArray = Structure.getStreamAsByteArray(stream);
                    if (structureAsByteArray.length <= 30000) {
                        Structurize.getNetwork().sendToServer((IMessage)new SchematicSaveMessage(structureAsByteArray, id, 1, 1));
                    } else {
                        int pieces = structureAsByteArray.length / 30000;
                        Log.getLogger().info("BuilderTool: sending: " + pieces + " pieces with the schematic " + structureName + "(md5:" + md5 + ") to the server");
                        for (int i = 1; i <= pieces; ++i) {
                            int start = (i - 1) * 30000;
                            int size = i == pieces ? structureAsByteArray.length - start : 30000;
                            byte[] bytes = new byte[size];
                            Array.copy((Object)structureAsByteArray, (int)start, (Object)bytes, (int)0, (int)size);
                            Structurize.getNetwork().sendToServer((IMessage)new SchematicSaveMessage(bytes, id, pieces, i));
                        }
                    }
                } else {
                    Log.getLogger().warn("BuilderTool: Can not load " + structureName);
                }
            } else {
                Log.getLogger().warn("BuilderTool: server does not have " + serverSideName);
            }
        } else {
            Log.getLogger().warn("BuilderTool: Can not send schematic without md5: " + structureName);
        }
    }

    public void place(StructureName structureName) {
    }

    public void checkAndPlace() {
    }

    public boolean hasPermission() {
        return Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d;
    }

    public boolean pasteDirectly() {
        return true;
    }

    public void paste(StructureName name, boolean complete) {
        Structurize.getNetwork().sendToServer((IMessage)new BuildToolPasteMessage(name.toString(), name.toString(), Settings.instance.getPosition(), Settings.instance.getRotation(), false, Settings.instance.getMirror(), complete, Settings.instance.getFreeMode()));
    }

    private void confirmClicked() {
        if (Settings.instance.isStaticSchematicMode() && Settings.instance.getActiveStructure() != null) {
            this.checkAndPlace();
        } else {
            StructureName structureName = new StructureName(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()));
            if (structureName.getPrefix().equals("scans") && FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
                this.requestAndPlaceScannedSchematic(structureName, false, false);
            }
            if (this.pasteDirectly()) {
                this.paste(structureName, false);
            } else {
                this.place(structureName);
            }
            if (!GuiScreen.func_146272_n()) {
                this.cancelClicked();
            }
        }
    }

    public void cancelClicked() {
        Settings.instance.reset();
        this.close();
    }

    private static void updateRotation(int rotation) {
        PlacementSettings settings = new PlacementSettings();
        switch (rotation) {
            case 1: {
                settings.func_186220_a(Rotation.CLOCKWISE_90);
                break;
            }
            case 2: {
                settings.func_186220_a(Rotation.CLOCKWISE_180);
                break;
            }
            case 3: {
                settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            default: {
                settings.func_186220_a(Rotation.NONE);
            }
        }
        Settings.instance.setRotation(rotation);
        if (Settings.instance.getActiveStructure() != null) {
            Settings.instance.getActiveStructure().setPlacementSettings(settings.func_186214_a(Settings.instance.getMirror()));
        }
    }

    private void renameClicked() {
        StructureName structureName = new StructureName(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()));
        WindowStructureNameEntry window = new WindowStructureNameEntry(structureName);
        window.open();
    }

    private void deleteClicked() {
        this.confirmDeleteDialog = new DialogDoneCancel(this.getWindow());
        this.confirmDeleteDialog.setHandler(this::onDialogClosed);
        StructureName structureName = new StructureName(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()));
        this.confirmDeleteDialog.setTitle(LanguageHandler.format("com.minecolonies.coremod.gui.structure.delete.title", new Object[0]));
        this.confirmDeleteDialog.setTextContent(LanguageHandler.format("com.minecolonies.coremod.gui.structure.delete.body", structureName.toString()));
        this.confirmDeleteDialog.open();
    }

    public void onDialogClosed(DialogDoneCancel dialog, int buttonId) {
        StructureName structureName;
        if (dialog == this.confirmDeleteDialog && buttonId == 1 && "scans".equals((structureName = new StructureName(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()))).getPrefix()) && Structures.deleteScannedStructure(structureName)) {
            Structures.loadScannedStyleMaps();
            if (this.schematics.size() > 1) {
                this.schematicsDropDownList.selectNext();
                this.stylesDropDownList.setSelectedIndex(this.stylesDropDownList.getSelectedIndex());
            } else if (this.styles.size() > 1) {
                this.stylesDropDownList.selectNext();
            } else {
                this.sectionsDropDownList.selectNext();
            }
        }
    }

    private class SectionDropDownList
    implements DropDownList.DataProvider {
        private SectionDropDownList() {
        }

        @Override
        public int getElementCount() {
            return WindowBuildTool.this.sections.size();
        }

        @Override
        public String getLabel(int index) {
            String name = (String)WindowBuildTool.this.sections.get(index);
            if ("scans".equals(name)) {
                return LanguageHandler.format("com.structurize.coremod.gui.buildtool.scans", new Object[0]);
            }
            if ("schematics".equals(name)) {
                return LanguageHandler.format("com.structurize.coremod.gui.buildtool.decorations", new Object[0]);
            }
            return WindowBuildTool.this.getSectionName(name);
        }
    }

    public static enum FreeMode {
        SUPPLYSHIP,
        SUPPLYCAMP;

    }
}

