/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod;

import com.structurize.coremod.management.Structures;
import com.structurize.coremod.network.messages.BuildToolPasteMessage;
import com.structurize.coremod.network.messages.GenerateAndPasteMessage;
import com.structurize.coremod.network.messages.MultiBlockChangeMessage;
import com.structurize.coremod.network.messages.RemoveBlockMessage;
import com.structurize.coremod.network.messages.RemoveEntityMessage;
import com.structurize.coremod.network.messages.ReplaceBlockMessage;
import com.structurize.coremod.network.messages.SaveScanMessage;
import com.structurize.coremod.network.messages.ScanOnServerMessage;
import com.structurize.coremod.network.messages.SchematicRequestMessage;
import com.structurize.coremod.network.messages.SchematicSaveMessage;
import com.structurize.coremod.network.messages.ServerUUIDMessage;
import com.structurize.coremod.network.messages.StructurizeStylesMessage;
import com.structurize.coremod.network.messages.UndoMessage;
import com.structurize.coremod.placementhandlers.CopyPastePlacementHandlers;
import com.structurize.coremod.proxy.IProxy;
import com.structurize.structures.helpers.Structure;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
@Mod(modid="structurize", name="Structurize", version="1.12.2-0.10.24-ALPHA", dependencies="after:gbook", acceptedMinecraftVersions="[1.12,1.13]")
public class Structurize {
    private static final Logger logger = LogManager.getLogger((String)"structurize");
    @Mod.Instance(value="structurize")
    public static Structurize instance;
    @SidedProxy(clientSide="com.structurize.coremod.proxy.ClientProxy", serverSide="com.structurize.coremod.proxy.ServerProxy")
    public static IProxy proxy;
    private static SimpleNetworkWrapper network;

    public static boolean isClient() {
        return proxy.isClient() && FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static boolean isServer() {
        return !proxy.isClient() && FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public static Logger getLogger() {
        return logger;
    }

    @Mod.EventHandler
    public void preInit(@NotNull FMLPreInitializationEvent event) {
        Structure.originFolders.add("structurize");
        proxy.registerEntities();
        proxy.registerEntityRendering();
        proxy.registerEvents();
        Configuration configuration = new Configuration(event.getSuggestedConfigurationFile());
        configuration.load();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Structurize.initializeNetwork();
        proxy.registerTileEntities();
        proxy.registerTileEntityRendering();
        proxy.registerRenderer();
        CopyPastePlacementHandlers.initHandlers();
    }

    private static synchronized void initializeNetwork() {
        int id = 0;
        network = NetworkRegistry.INSTANCE.newSimpleChannel("Structurize");
        Structurize.getNetwork().registerMessage(ServerUUIDMessage.class, ServerUUIDMessage.class, ++id, Side.CLIENT);
        Structurize.getNetwork().registerMessage(BuildToolPasteMessage.class, BuildToolPasteMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(ScanOnServerMessage.class, ScanOnServerMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(RemoveBlockMessage.class, RemoveBlockMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(RemoveEntityMessage.class, RemoveEntityMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(ReplaceBlockMessage.class, ReplaceBlockMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(GenerateAndPasteMessage.class, GenerateAndPasteMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(SchematicRequestMessage.class, SchematicRequestMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(SchematicSaveMessage.class, SchematicSaveMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(UndoMessage.class, UndoMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(StructurizeStylesMessage.class, StructurizeStylesMessage.class, ++id, Side.CLIENT);
        Structurize.getNetwork().registerMessage(MultiBlockChangeMessage.class, MultiBlockChangeMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(SaveScanMessage.class, SaveScanMessage.class, ++id, Side.CLIENT);
        Structurize.getNetwork().registerMessage(SchematicSaveMessage.class, SchematicSaveMessage.class, ++id, Side.CLIENT);
    }

    @Mod.EventHandler
    public void serverAboutLoad(FMLServerAboutToStartEvent event) {
        Structures.init();
    }

    public static SimpleNetworkWrapper getNetwork() {
        return network;
    }
}

