/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.blockout.views;

import com.structurize.blockout.Pane;
import com.structurize.blockout.PaneParams;
import com.structurize.blockout.views.ScrollingContainer;
import com.structurize.blockout.views.ScrollingListContainer;
import com.structurize.blockout.views.ScrollingView;
import java.util.List;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;

public class ScrollingList
extends ScrollingView {
    protected DataProvider dataProvider;
    private PaneParams listNodeParams;

    public ScrollingList() {
    }

    public ScrollingList(PaneParams params) {
        super(params);
    }

    public void setDataProvider(final IntSupplier countSupplier, final IPaneUpdater paneUpdater) {
        this.setDataProvider(new DataProvider(){

            @Override
            public int getElementCount() {
                return countSupplier.getAsInt();
            }

            @Override
            public void updateElement(int index, Pane rowPane) {
                paneUpdater.apply(index, rowPane);
            }
        });
    }

    public void setDataProvider(DataProvider p) {
        this.dataProvider = p;
        this.refreshElementPanes();
    }

    public void refreshElementPanes() {
        ((ScrollingListContainer)this.container).refreshElementPanes(this.dataProvider, this.listNodeParams);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.refreshElementPanes();
    }

    @Override
    @NotNull
    protected ScrollingContainer createScrollingContainer() {
        return new ScrollingListContainer(this);
    }

    @Override
    public void parseChildren(@NotNull PaneParams params) {
        List<PaneParams> childNodes = params.getChildren();
        if (childNodes == null) {
            return;
        }
        this.listNodeParams = childNodes.get(0);
    }

    public int getListElementIndexByPane(Pane pane) {
        return ((ScrollingListContainer)this.container).getListElementIndexByPane(pane);
    }

    @FunctionalInterface
    public static interface IPaneUpdater {
        public void apply(int var1, Pane var2);
    }

    public static interface DataProvider {
        public int getElementCount();

        public void updateElement(int var1, Pane var2);
    }
}

