/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.blockout;

import com.structurize.blockout.Log;
import com.structurize.blockout.Pane;
import com.structurize.blockout.PaneParams;
import com.structurize.blockout.controls.ButtonImage;
import com.structurize.blockout.controls.ButtonVanilla;
import com.structurize.blockout.controls.Image;
import com.structurize.blockout.controls.ItemIcon;
import com.structurize.blockout.controls.Label;
import com.structurize.blockout.controls.Text;
import com.structurize.blockout.controls.TextFieldVanilla;
import com.structurize.blockout.views.Box;
import com.structurize.blockout.views.DropDownList;
import com.structurize.blockout.views.Group;
import com.structurize.blockout.views.OverlayView;
import com.structurize.blockout.views.ScrollingGroup;
import com.structurize.blockout.views.ScrollingList;
import com.structurize.blockout.views.SwitchView;
import com.structurize.blockout.views.View;
import com.structurize.blockout.views.Window;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Loader {
    private static final Map<String, Constructor<? extends Pane>> paneConstructorMap = new HashMap<String, Constructor<? extends Pane>>();

    private Loader() {
    }

    private static void register(String name, Class<? extends Pane> paneClass) {
        Loader.register(name, null, paneClass);
    }

    private static void register(String name, String style, Class<? extends Pane> paneClass) {
        String key = Loader.makeFactoryKey(name, style);
        if (paneConstructorMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate pane type '" + name + "' of style '" + style + "' when registering Pane class mapping for " + paneClass.getName());
        }
        try {
            Constructor<? extends Pane> constructor = paneClass.getDeclaredConstructor(PaneParams.class);
            paneConstructorMap.put(key, constructor);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing (XMLNode) constructor for type '" + name + "' when adding Pane class mapping for " + paneClass.getName(), exception);
        }
    }

    @NotNull
    private static String makeFactoryKey(String name, String style) {
        return name + ":" + (style != null ? style : "");
    }

    private static Pane createFromPaneParams(PaneParams params) {
        String style;
        String paneType = params.getType();
        String key = Loader.makeFactoryKey(paneType, style = params.getStringAttribute("style", null));
        Constructor<? extends Pane> constructor = paneConstructorMap.get(key);
        if (constructor == null && style != null) {
            key = Loader.makeFactoryKey(paneType, null);
            constructor = paneConstructorMap.get(key);
        }
        if (constructor != null) {
            try {
                return constructor.newInstance(params);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException exc) {
                Log.getLogger().error(String.format("Exception when parsing XML for pane type %s", paneType), (Throwable)exc);
            }
        }
        return null;
    }

    public static Pane createFromPaneParams(PaneParams params, View parent) {
        if ("layout".equalsIgnoreCase(params.getType())) {
            String resource = params.getStringAttribute("source", null);
            if (resource != null) {
                Loader.createFromXMLFile(resource, parent);
            }
            return null;
        }
        params.setParentView(parent);
        Pane pane = Loader.createFromPaneParams(params);
        if (pane != null) {
            pane.putInside(parent);
            pane.parseChildren(params);
        }
        return pane;
    }

    private static void createFromXML(Document doc, View parent) {
        doc.getDocumentElement().normalize();
        PaneParams root = new PaneParams(doc.getDocumentElement());
        if (parent instanceof Window) {
            ((Window)parent).loadParams(root);
        }
        for (PaneParams child : root.getChildren()) {
            Loader.createFromPaneParams(child, parent);
        }
    }

    private static void createFromXML(InputSource input, View parent) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(input);
            Loader.createFromXML(doc, parent);
        }
        catch (IOException | ParserConfigurationException | SAXException exc) {
            Log.getLogger().error("Exception when parsing XML.", (Throwable)exc);
        }
    }

    public static void createFromXML(String xmlString, View parent) {
        Loader.createFromXML(new InputSource(new StringReader(xmlString)), parent);
    }

    public static void createFromXMLFile(String filename, View parent) {
        Loader.createFromXMLFile(new ResourceLocation(filename), parent);
    }

    public static void createFromXMLFile(ResourceLocation resource, View parent) {
        Loader.createFromXML(new InputSource(Loader.createInputStream(resource)), parent);
    }

    private static InputStream createInputStream(ResourceLocation res) {
        try {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return Minecraft.func_71410_x().func_110442_L().func_110536_a(res).func_110527_b();
            }
            return Loader.class.getResourceAsStream(String.format("/assets/%s/%s", res.func_110624_b(), res.func_110623_a()));
        }
        catch (IOException e) {
            Log.getLogger().error("IOException Loader.java", (Throwable)e);
            return null;
        }
    }

    static {
        Loader.register("view", View.class);
        Loader.register("group", Group.class);
        Loader.register("scrollgroup", ScrollingGroup.class);
        Loader.register("list", ScrollingList.class);
        Loader.register("text", Text.class);
        Loader.register("button", ButtonVanilla.class);
        Loader.register("buttonimage", ButtonImage.class);
        Loader.register("label", Label.class);
        Loader.register("input", TextFieldVanilla.class);
        Loader.register("image", Image.class);
        Loader.register("box", Box.class);
        Loader.register("itemicon", ItemIcon.class);
        Loader.register("switch", SwitchView.class);
        Loader.register("dropdown", DropDownList.class);
        Loader.register("overlay", OverlayView.class);
    }
}

