/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.api.util;

import com.structurize.api.util.BlockPosUtil;
import com.structurize.api.util.Log;
import java.io.File;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    private Utils() {
    }

    @Nullable
    public static BlockPos scanForBlockNearPoint(@NotNull World world, @NotNull BlockPos point, int radiusX, int radiusY, int radiusZ, int height, Block ... blocks) {
        BlockPos closestCoords = null;
        double minDistance = Double.MAX_VALUE;
        for (int i = point.func_177958_n() - radiusX; i <= point.func_177958_n() + radiusX; ++i) {
            for (int j = point.func_177956_o() - radiusY; j <= point.func_177956_o() + radiusY; ++j) {
                for (int k = point.func_177952_p() - radiusZ; k <= point.func_177952_p() + radiusZ; ++k) {
                    if (!Utils.checkHeight(world, i, j, k, height, blocks)) continue;
                    BlockPos tempCoords = new BlockPos(i, j, k);
                    double distance = BlockPosUtil.getDistanceSquared(tempCoords, point);
                    if (closestCoords != null && !(distance < minDistance)) continue;
                    closestCoords = tempCoords;
                    minDistance = distance;
                }
            }
        }
        return closestCoords;
    }

    private static boolean checkHeight(@NotNull World world, int x, int y, int z, int height, Block ... blocks) {
        for (int dy = 0; dy < height; ++dy) {
            if (Utils.arrayContains(blocks, world.func_180495_p(new BlockPos(x, y + dy, z)).func_177230_c())) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayContains(@NotNull Object[] array, Object key) {
        for (Object o : array) {
            if (!Objects.equals(key, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockInRange(@NotNull World world, Block block, int posX, int posY, int posZ, int range) {
        for (int x = posX - range; x < posX + range; ++x) {
            for (int z = posZ - range; z < posZ + range; ++z) {
                for (int y = posY - range; y < posY + range; ++y) {
                    if (!Objects.equals(world.func_180495_p(new BlockPos(x, y, z)).func_177230_c(), block)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int findTopGround(@NotNull World world, int x, int z) {
        int yHolder = 1;
        while (!world.func_175710_j(new BlockPos(x, yHolder, z))) {
            ++yHolder;
        }
        while (!world.func_180495_p(new BlockPos(x, yHolder, z)).func_185914_p() || Utils.arrayContains(new Block[]{Blocks.field_150350_a, Blocks.field_150362_t, Blocks.field_150361_u}, world.func_180495_p(new BlockPos(x, yHolder, z)).func_177230_c())) {
            --yHolder;
        }
        return yHolder;
    }

    public static boolean testFlag(int data, int flag) {
        return Utils.mask(data, flag) == flag;
    }

    public static int mask(int data, int mask) {
        return data & mask;
    }

    public static int setFlag(int data, int flag) {
        return data | flag;
    }

    public static int unsetFlag(int data, int flag) {
        return data & ~flag;
    }

    public static int toggleFlag(int data, int flag) {
        return data ^ flag;
    }

    public static void checkDirectory(@NotNull File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }
}

