/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.api.util;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageHandler {
    private LanguageHandler() {
    }

    public static void sendPlayerMessage(@NotNull EntityPlayer player, String key, Object ... message) {
        player.func_145747_a(LanguageHandler.buildChatComponent(key, message));
    }

    private static ITextComponent buildChatComponent(String key, Object ... message) {
        TextComponentTranslation translation = null;
        int onlyArgsUntil = 0;
        for (Object object : message) {
            if (object instanceof ITextComponent) {
                if (onlyArgsUntil != 0) break;
                onlyArgsUntil = -1;
                break;
            }
            ++onlyArgsUntil;
        }
        if (onlyArgsUntil >= 0) {
            Object[] args = new Object[onlyArgsUntil];
            System.arraycopy(message, 0, args, 0, onlyArgsUntil);
            translation = new TextComponentTranslation(key, args);
        }
        for (Object object : message) {
            if (translation == null) {
                if (object instanceof ITextComponent) {
                    translation = new TextComponentTranslation(key, new Object[0]);
                } else {
                    translation = new TextComponentTranslation(key, new Object[]{object});
                    continue;
                }
            }
            if (object instanceof ITextComponent) {
                translation.func_150257_a((ITextComponent)object);
                continue;
            }
            if (!(object instanceof String)) continue;
            boolean isInArgs = false;
            for (Object obj : translation.func_150271_j()) {
                if (!obj.equals(object)) continue;
                isInArgs = true;
                break;
            }
            if (isInArgs) continue;
            translation.func_150258_a((String)object);
        }
        if (translation == null) {
            translation = new TextComponentTranslation(key, new Object[0]);
        }
        return translation;
    }

    public static String format(String key, Object ... args) {
        String result = args.length == 0 ? new TextComponentTranslation(key, new Object[0]).func_150260_c() : new TextComponentTranslation(key, args).func_150260_c();
        return result.isEmpty() ? key : result;
    }

    public static void sendPlayersMessage(@Nullable List<EntityPlayer> players, String key, Object ... message) {
        if (players == null || players.isEmpty()) {
            return;
        }
        ITextComponent textComponent = LanguageHandler.buildChatComponent(key, message);
        for (EntityPlayer player : players) {
            player.func_145747_a(textComponent);
        }
    }
}

