/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.worldgen.nbt;

import java.util.Random;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.thedragonteam.armorplus.DevUtils;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.armorplus.util.WorldGenUtils;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class StructureGenNBT
implements IWorldGenerator {
    public static final ResourceLocation TOWER = Utils.setRL("tower");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int posX = WorldGenUtils.getExactRandPos(chunkX, random);
        int posZ = WorldGenUtils.getExactRandPos(chunkZ, random);
        BlockPos posXZ = new BlockPos(posX, 1, posZ);
        Biome biome = world.getBiomeForCoordsBody(posXZ);
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer serverworld = (WorldServer)world;
        int posY = WorldGenUtils.getGroundFromAbove(world, posX, posZ);
        BlockPos basePos = new BlockPos(posX, posY, posZ);
        if (ModConfig.WorldGenConfig.tower.shouldOnlyGenerateInTheOverworld) {
            if (world.field_73011_w.getDimension() == 0) {
                this.generateTowerWithChecks(biome, serverworld, random, basePos);
            }
        } else {
            this.generateTowerWithChecks(biome, serverworld, random, basePos);
        }
    }

    public void generateTowerWithChecks(Biome biome, WorldServer serverworld, Random random, BlockPos basePos) {
        BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HOT).forEach(hotBiome -> {
            boolean isBiomeEligible = this.checkEligibility((Biome)hotBiome);
            if (isBiomeEligible && biome == hotBiome) {
                this.generateTower(serverworld, random, basePos);
            }
        });
    }

    public boolean checkEligibility(Biome hotBiome) {
        return !BiomeDictionary.hasType((Biome)hotBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) && !BiomeDictionary.hasType((Biome)hotBiome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
    }

    public void generateTower(WorldServer world, Random random, BlockPos pos) {
        if (ModConfig.WorldGenConfig.tower.enable && (random.nextInt(ModConfig.WorldGenConfig.tower.chanceNeededForSpawning) < ModConfig.WorldGenConfig.tower.spawnChance || DevUtils.enableTowerDevEnv() && random.nextInt(100) < 10)) {
            PlacementSettings settings = new PlacementSettings();
            settings.func_186220_a(Rotation.NONE);
            MinecraftServer server = world.func_73046_m();
            Template template = world.func_72860_G().func_186340_h().func_186237_a(server, TOWER);
            template.func_186253_b((World)world, pos, settings);
            if (ModConfig.DebugConfig.debugMode || DevUtils.enableTowerDevEnv()) {
                LogHelper.info((Object)("Tower generated at: " + pos));
            }
        }
    }
}

