/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.util;

import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenUtils {
    public static final int CHUNK_SIZE = 16;

    public static int getGroundFromAbove(World world, int x, int z) {
        int y = 255;
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = blockAt == Blocks.field_150355_j || blockAt == Blocks.field_150358_i || blockAt == Blocks.field_150353_l || blockAt == Blocks.field_150356_k || blockAt != Blocks.field_150350_a;
        }
        return y;
    }

    public static void runGenerator(WorldGenerator generator, World world, Random rand, int chunkX, int chunkZ, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new AssertionError((Object)String.format("Illegal Height Arguments for WorldGenerator. Min height must in the range (0, %d) [Value: %d]. Max height must not be greater than 256. [Value: %d", maxHeight, minHeight, maxHeight));
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int y = minHeight + rand.nextInt(heightDiff);
            int x = WorldGenUtils.getExactRandPos(chunkX, rand);
            int z = WorldGenUtils.getExactRandPos(chunkZ, rand);
            BlockPos orePos = new BlockPos(x, y, z);
            generator.func_180709_b(world, rand, orePos);
        }
    }

    public static void runGenerator(WorldGenerator generator, World world, Random rand, int chunkX, int chunkZ, int chancesToSpawn, int posY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = WorldGenUtils.getExactRandPos(chunkX, rand);
            int z = WorldGenUtils.getExactRandPos(chunkZ, rand);
            BlockPos orePos = new BlockPos(x, posY, z);
            generator.func_180709_b(world, rand, orePos);
        }
    }

    public static int getExactRandPos(int chunk, Random rand) {
        return WorldGenUtils.x16(chunk) + rand.nextInt(16);
    }

    public static int x16(int chunkCord) {
        return chunkCord * 16;
    }

    public static void runGenerator(WorldGenerator generator, World world, Random rand, int chancesToSpawn, BlockPos blockPos) {
        IntStream.range(0, chancesToSpawn).forEachOrdered(i -> generator.func_180709_b(world, rand, blockPos));
    }
}

