/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.thedragonteam.armorplus.util.LoaderUtils;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public final class Utils {
    public static final int WILDCARD = Short.MAX_VALUE;
    public static ItemStack[] emptyArmor = new ItemStack[4];
    public static EntityEquipmentSlot[] equipmentSlots = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    public static List<String> boxList(String[] objects) {
        return Arrays.stream(objects).collect(Collectors.toList());
    }

    public static List<Integer> boxList(int[] objects) {
        return Arrays.stream(objects).boxed().collect(Collectors.toList());
    }

    public static int convertToSeconds(int seconds) {
        return seconds * 20;
    }

    public static ItemStack checkNBT(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack;
    }

    public static ItemStack setUnbreakable(ItemStack stack) {
        Utils.checkNBT(stack);
        stack.func_77978_p().func_74757_a("Unbreakable", true);
        return stack;
    }

    public static ItemStack getStackFromSlot(EntityPlayer player, EntityEquipmentSlot slot) {
        return player.func_184582_a(slot);
    }

    public static String setName(String name) {
        return String.format("%s.%s", "armorplus", name);
    }

    public static NonNullList<ItemStack> getItemStacks(Item ... items) {
        NonNullList list = NonNullList.func_191196_a();
        if (items != null) {
            Arrays.stream(items).map(ItemStackUtils::getItemStack).forEachOrdered(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public static NonNullList<ItemStack> getItemStacks(ItemStack ... items) {
        NonNullList list = NonNullList.func_191196_a();
        list.addAll(Arrays.asList(items));
        return list;
    }

    public static String getUnlocalizedNames(ItemStack stack, String key, String ... names) {
        for (int i = 0; i < names.length; ++i) {
            if (stack.func_77952_i() != i) continue;
            return key + names[i];
        }
        return key;
    }

    public static ResourceLocation setRL(String path) {
        return new ResourceLocation("armorplus", path);
    }

    public static String setLocation(String path) {
        return String.format("%s:%s", "armorplus", path);
    }

    public static boolean isNotEmpty(ItemStack stack) {
        return !stack.func_190926_b();
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack.func_190926_b();
    }

    public static boolean isNotNull(Object object) {
        return object != null;
    }

    public static boolean areNotNull(Object object1, Object object2) {
        return object1 != null && object2 != null;
    }

    public static boolean isNotNullNorEmpty(String object) {
        return Utils.isNotNull(object) && !Objects.equals(object, "");
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNullOrEmpty(String object) {
        return Utils.isNull(object) || Objects.equals(object, "");
    }

    public static ItemStack getTCIngot(int meta) {
        if (LoaderUtils.isTiCLoaded()) {
            Item ingot = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tconstruct:ingots"));
            if (ingot != null) {
                return new ItemStack(ingot, 1, meta);
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    static {
        Arrays.fill(emptyArmor, ItemStack.field_190927_a);
    }
}

