/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Map;

public class JsonUtils {
    public static JsonArray addArray(String propertyName, JsonElement element) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((JsonElement)JsonUtils.addProperty(propertyName, element));
        return jsonArray;
    }

    public static JsonArray addArray(Map<String, JsonElement> properties) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((JsonElement)JsonUtils.addProperty(properties));
        return jsonArray;
    }

    public static JsonArray addArray(JsonObject jsonObject) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((JsonElement)jsonObject);
        return jsonArray;
    }

    public static JsonArray addArray(JsonObject ... jsonObjects) {
        JsonArray jsonArray = new JsonArray();
        Arrays.stream(jsonObjects).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        return jsonArray;
    }

    public static JsonObject addProperty(String propertyName, JsonElement element) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(propertyName, element);
        return jsonObject;
    }

    public static JsonObject addProperty(String propertyName, Object element) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(propertyName, JsonUtils.getPrimitive(element));
        return jsonObject;
    }

    public static JsonObject addProperty(Map<String, JsonElement> properties) {
        JsonObject jsonObject = new JsonObject();
        properties.forEach((arg_0, arg_1) -> ((JsonObject)jsonObject).add(arg_0, arg_1));
        return jsonObject;
    }

    public static JsonElement getPrimitive(Object object) {
        if (object instanceof Boolean) {
            return new JsonPrimitive((Boolean)object);
        }
        if (object instanceof Number) {
            return new JsonPrimitive((Number)object);
        }
        if (object instanceof String) {
            return new JsonPrimitive((String)object);
        }
        if (object instanceof Character) {
            return new JsonPrimitive((Character)object);
        }
        return new JsonObject();
    }
}

