/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.util;

import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.EnumHelper;
import net.thedragonteam.armorplus.armors.APArmorMaterial;
import net.thedragonteam.armorplus.util.EnumTiers;
import net.thedragonteam.armorplus.util.Utils;

public class EnumHelperUtil {
    public static EnumRarity addRarity(String enumName, Object color, String displayName) {
        if (color instanceof TextFormatting) {
            return EnumHelper.addRarity((String)enumName, (TextFormatting)((TextFormatting)color), (String)displayName);
        }
        if (color instanceof String) {
            return EnumHelper.addRarity((String)enumName, (TextFormatting)TextFormatting.func_96300_b((String)((String)color)), (String)displayName);
        }
        if (color instanceof Integer) {
            return EnumHelper.addRarity((String)enumName, (TextFormatting)TextFormatting.func_175744_a((int)((Integer)color)), (String)displayName);
        }
        return EnumRarity.COMMON;
    }

    public static EnumEnchantmentType addEnchantType(String enumName, Predicate<Item> itemPredicate) {
        return EnumHelper.addEnchantmentType((String)enumName, itemPredicate::test);
    }

    public static EnumAction addAction(String enumName) {
        return EnumHelper.addAction((String)enumName);
    }

    public static EntityPlayer.SleepResult addStatus(String enumName) {
        return EnumHelper.addStatus((String)enumName);
    }

    public static ItemArmor.ArmorMaterial addArmorMaterial(String enumName, String textureName, int durability, int[] armorPoints, int enchantability, SoundEvent soundOnEquip, double toughnessPoints) {
        return EnumHelper.addArmorMaterial((String)enumName, (String)Utils.setLocation(textureName), (int)durability, (int[])armorPoints, (int)enchantability, (SoundEvent)soundOnEquip, (float)((float)toughnessPoints));
    }

    public static ItemArmor.ArmorMaterial addArmorMaterial(String enumName, String textureName, int durability, int[] armorPoints, double toughnessPoints, EnumTiers enumTiers) {
        return EnumHelperUtil.addArmorMaterial(enumName, textureName, durability, armorPoints, enumTiers.getEnchantability(), SoundEvents.field_191258_p, toughnessPoints);
    }

    public static HorseArmorType addHorseArmor(String name, int armorStrength) {
        return EnumHelper.addHorseArmor((String)name, (String)("armorplus:textures/entity/horse/armor/" + name + ".png"), (int)armorStrength);
    }

    public static HorseArmorType addHorseArmor(APArmorMaterial material, int armorStrength) {
        return EnumHelper.addHorseArmor((String)material.getName(), (String)("armorplus:textures/entity/horse/armor/" + material.getName() + ".png"), (int)armorStrength);
    }

    public static Enchantment getEnchantment(int nameOrId) {
        return Enchantment.func_185262_c((int)nameOrId);
    }

    public static Enchantment getEnchantment(String nameOrId) {
        return Enchantment.func_180305_b((String)nameOrId);
    }

    public static int getID(Enchantment enchant) {
        return Enchantment.func_185258_b((Enchantment)enchant);
    }
}

