/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.util;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.thedragonteam.armorplus.api.properties.AbilityCanceller;
import net.thedragonteam.armorplus.api.properties.AbilityProvider;
import net.thedragonteam.armorplus.api.properties.iface.IEffectHolder;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.items.weapons.effects.Negative;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.Utils;

public final class ArmorPlusItemUtils {
    private ArmorPlusItemUtils() {
    }

    public static boolean isItemRepairable(ItemStack repair, ItemStack expert) {
        return ModConfig.getRD().isItemRepairable(repair, expert);
    }

    public static boolean isFullSet(EntityPlayer player, Item head, Item chest, Item legs, Item feet) {
        ItemStack feetStack;
        ItemStack legsStack;
        ItemStack chestStack;
        ItemStack headStack = ArmorPlusItemUtils.getHead(player);
        return !ArmorPlusItemUtils.isArmorEmpty(headStack, chestStack = ArmorPlusItemUtils.getChest(player), legsStack = ArmorPlusItemUtils.getLegs(player), feetStack = ArmorPlusItemUtils.getFeet(player)) && ArmorPlusItemUtils.areEqual(headStack, head) && ArmorPlusItemUtils.areEqual(chestStack, chest) && ArmorPlusItemUtils.areEqual(legsStack, legs) && ArmorPlusItemUtils.areEqual(feetStack, feet);
    }

    public static boolean areEqual(ItemStack a, Item b) {
        return a.func_77973_b() == b;
    }

    public static boolean isArmorEmpty(ItemStack helmet, ItemStack chestplate, ItemStack leggings, ItemStack boots) {
        return helmet.func_190926_b() || chestplate.func_190926_b() || leggings.func_190926_b() || boots.func_190926_b();
    }

    public static ItemStack getHead(EntityPlayer player) {
        return player.func_184582_a(EntityEquipmentSlot.HEAD);
    }

    public static ItemStack getChest(EntityPlayer player) {
        return player.func_184582_a(EntityEquipmentSlot.CHEST);
    }

    public static ItemStack getLegs(EntityPlayer player) {
        return player.func_184582_a(EntityEquipmentSlot.LEGS);
    }

    public static ItemStack getFeet(EntityPlayer player) {
        return player.func_184582_a(EntityEquipmentSlot.FEET);
    }

    public static void applyEffects(EntityPlayer player, IEffectHolder effectHolder) {
        AbilityProvider applicable = effectHolder.getApplicableAbilities();
        AbilityCanceller removable = effectHolder.getRemovableAbilities();
        ArmorPlusItemUtils.applyEffects(player, Utils.boxList(applicable.getAbilities().name), Utils.boxList(applicable.getAbilities().duration), Utils.boxList(applicable.getAbilities().level), Utils.boxList(removable.getAbilities()));
    }

    public static void applyEffects(EntityPlayer player, List<String> applyEffectNames, List<Integer> applyEffectDurations, List<Integer> applyEffectLevels, List<String> removableEffects) {
        List potions = applyEffectNames.stream().map(PotionUtils::getPotion).collect(Collectors.toList());
        int bound = potions.size();
        for (int potionID = 0; potionID < bound; ++potionID) {
            if (potions.isEmpty()) {
                return;
            }
            Potion potionEffect2 = (Potion)potions.get(potionID);
            if (player.func_70660_b(potionEffect2) != null && potionEffect2 != MobEffects.field_76439_r) continue;
            int duration = Utils.convertToSeconds(applyEffectDurations.get(potionID));
            int level = applyEffectLevels.get(potionID);
            PotionUtils.addPotion((EntityLivingBase)player, potionEffect2, duration, level, PotionUtils.PotionType.GOOD);
        }
        List removablePotions = removableEffects.stream().map(PotionUtils::getPotion).collect(Collectors.toList());
        removablePotions.stream().filter(potionEffect -> player.func_70660_b(potionEffect) != null).forEach(arg_0 -> ((EntityPlayer)player).func_184596_c(arg_0));
    }

    public static void applyNegativeEffect(EntityLivingBase target, Negative effect) {
        if (effect.isEnabled()) {
            IntStream.range(0, effect.getEffects().length).forEach(potionID -> {
                Potion negative = PotionUtils.getPotion(effect.getEffects()[potionID]);
                int duration = Utils.convertToSeconds(effect.getEffectDurations()[potionID]);
                int level = effect.getEffectLevels()[potionID];
                PotionUtils.addPotion(target, negative, duration, level, PotionUtils.PotionType.BAD);
            });
        }
    }
}

