/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.tileentity.base;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.tileentity.base.TileEntityInventoryBase;

public abstract class TileBench
extends TileEntityInventoryBase {
    public NonNullList<ItemStack> inventory;
    private int inventorySize;
    private String tileEntityName;
    private String customName;

    public TileBench(String tileEntityName, int inventorySize) {
        super(inventorySize);
        this.tileEntityName = tileEntityName;
        this.inventorySize = inventorySize;
        this.inventory = this.itemHandler.getItems();
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return IntStream.rangeClosed(0, this.itemHandler.getSlots()).anyMatch(i -> this.itemHandler.getStackInSlot(slot) != ItemStack.field_190927_a);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack) {
        return IntStream.rangeClosed(0, this.itemHandler.getSlots()).anyMatch(i -> this.itemHandler.getStackInSlot(slot) != ItemStack.field_190927_a);
    }

    @Override
    public int getMaxStackSizePerSlot(int slot) {
        return 128;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : "container.armorplus." + this.tileEntityName;
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.equals("");
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.tileEntityName) : new TextComponentTranslation(this.tileEntityName, new Object[0]);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        IntStream.range(0, this.inventorySize).filter(i -> !this.itemHandler.getStackInSlot(i).func_190926_b()).forEachOrdered(i -> {
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.itemHandler.getStackInSlot(i).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        });
        nbt.func_74782_a("Items", (NBTBase)list);
        if (this.hasCustomName()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        IntStream.range(0, list.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)list).func_150305_b(arg_0)).forEachOrdered(stackTag -> {
            int slot = stackTag.func_74771_c("Slot") & 0xFF;
            this.itemHandler.setStackInSlot(slot, new ItemStack(stackTag));
        });
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

