/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTrophy
extends TileEntity {
    public WeightedSpawnerEntity entityData = new WeightedSpawnerEntity();
    private Entity cachedEntity;
    private float scale;
    private String customName;

    public String getName() {
        return this.hasCustomName() ? this.customName : "container.trophy";
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public ResourceLocation getEntityId() {
        String s = this.entityData.func_185277_b().func_74779_i("id");
        return StringUtils.func_151246_b((String)s) ? new ResourceLocation("minecraft:pig") : new ResourceLocation(s);
    }

    public void setEntityId(@Nullable ResourceLocation id) {
        if (id != null && ForgeRegistries.ENTITIES.containsKey(id)) {
            this.entityData.func_185277_b().func_74778_a("id", id.toString());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.loadFromNbt(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.saveToNbt(nbt);
        return nbt;
    }

    public Entity getCachedEntity() {
        if (this.cachedEntity == null) {
            this.cachedEntity = AnvilChunkLoader.func_186051_a((NBTTagCompound)this.entityData.func_185277_b(), (World)this.func_145831_w(), (boolean)false);
            if (this.entityData.func_185277_b().func_186856_d() == 1 && this.entityData.func_185277_b().func_150297_b("id", 8) && this.cachedEntity instanceof EntityLiving) {
                ((EntityLiving)this.cachedEntity).func_180482_a(this.func_145831_w().func_175649_E(new BlockPos(this.cachedEntity)), null);
            }
        }
        return this.cachedEntity;
    }

    public float getEntityScale() {
        return this.scale;
    }

    public void setEntityScale(float scale) {
        this.scale = scale;
    }

    public static void registerTrophyFixes(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (fixer1, compound, versionIn) -> {
            if (TileEntity.func_190559_a(TileTrophy.class).equals((Object)new ResourceLocation(compound.func_74779_i("id")))) {
                compound.func_74782_a("DisplayEntity", (NBTBase)fixer1.func_188251_a((IFixType)FixTypes.ENTITY, compound.func_74775_l("DisplayEntity"), versionIn));
            }
            return compound;
        });
    }

    public void loadFromNbt(NBTTagCompound nbt) {
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        if (nbt.func_150297_b("DisplayEntity", 10)) {
            this.setNextEntityData(new WeightedSpawnerEntity(1, nbt.func_74775_l("DisplayEntity")));
        }
        if (nbt.func_150297_b("EntityScale", 99)) {
            this.scale = nbt.func_74760_g("EntityScale");
        }
        this.cachedEntity = null;
    }

    public NBTTagCompound saveToNbt(NBTTagCompound nbt) {
        ResourceLocation resourcelocation;
        if (this.hasCustomName()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        if ((resourcelocation = this.getEntityId()) == null) {
            return nbt;
        }
        nbt.func_74776_a("EntityScale", this.scale);
        nbt.func_74782_a("DisplayEntity", (NBTBase)this.entityData.func_185277_b().func_74737_b());
        return nbt;
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    public BlockPos func_174877_v() {
        return this.field_174879_c;
    }

    public void setNextEntityData(WeightedSpawnerEntity entityData) {
        this.entityData = entityData;
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.func_145831_w() != null) {
            IBlockState iblockstate = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.field_174879_c, iblockstate, iblockstate, 4);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 12, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean func_183000_F() {
        return false;
    }

    public boolean func_145842_c(int id, int type) {
        return super.func_145842_c(id, type);
    }
}

