/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.registry;

import java.util.stream.IntStream;
import net.thedragonteam.armorplus.armors.APArmorMaterial;
import net.thedragonteam.armorplus.armors.base.ItemArmorBase;
import net.thedragonteam.armorplus.armors.base.ItemUltimateArmor;
import net.thedragonteam.armorplus.items.base.ItemSpecialBattleAxe;
import net.thedragonteam.armorplus.items.base.ItemSpecialBow;
import net.thedragonteam.armorplus.items.base.ItemSpecialSword;
import net.thedragonteam.armorplus.items.weapons.BattleAxes;
import net.thedragonteam.armorplus.items.weapons.Bows;
import net.thedragonteam.armorplus.items.weapons.Swords;
import net.thedragonteam.armorplus.util.Utils;

public class ModRegistryUtils {
    public static void register(boolean enabled, ItemArmorBase[] armor, APArmorMaterial armorMaterial) {
        if (enabled) {
            IntStream.range(0, armor.length).forEachOrdered(i -> {
                armor[i] = new ItemArmorBase(armorMaterial, Utils.equipmentSlots[i]);
            });
        }
    }

    public static void register(boolean enabled, ItemUltimateArmor[] armor) {
        if (enabled) {
            IntStream.range(0, armor.length).forEachOrdered(i -> {
                armor[i] = new ItemUltimateArmor(Utils.equipmentSlots[i]);
            });
        }
    }

    public static void register(boolean[] enabled, ItemSpecialSword[] sword, Swords[] material) {
        IntStream.range(0, enabled.length).filter(i -> enabled[i]).forEachOrdered(i -> {
            sword[i] = new ItemSpecialSword(material[i]);
        });
    }

    public static void register(boolean[] enabled, ItemSpecialBattleAxe[] battleAxe, BattleAxes[] material) {
        IntStream.range(0, enabled.length).filter(i -> enabled[i]).forEachOrdered(i -> {
            battleAxe[i] = new ItemSpecialBattleAxe(material[i]);
        });
    }

    public static void register(boolean[] enabled, ItemSpecialBow[] bow, Bows[] material) {
        IntStream.range(0, enabled.length).filter(i -> enabled[i]).forEachOrdered(i -> {
            bow[i] = new ItemSpecialBow(material[i]);
        });
    }
}

