/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.registry;

import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.thedragonteam.armorplus.api.crafting.base.BaseShapedOreRecipe;
import net.thedragonteam.armorplus.api.crafting.base.BaseShapelessOreRecipe;
import net.thedragonteam.armorplus.api.crafting.workbench.WorkbenchRegistry;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.registry.ModOreDicts;
import net.thedragonteam.armorplus.util.LoaderUtils;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public class ModRecipes {
    private static ModConfig.RegistryConfig.GlobalRegistry gr = ModConfig.RegistryConfig.global_registry;

    public static void init() {
        ModRecipes.addShapedRecipes();
        ModRecipes.addShapelessRecipes();
        if (LoaderUtils.isTOPIntegrationEnabled()) {
            ModRecipes.addIntegrationShapelessRecipes();
        }
    }

    private static void addIntegrationShapelessRecipes() {
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableEnderDragonArmor, "ender_dragon_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableGuardianArmor, "guardian_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableSuperStarArmor, "super_star_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableTheUltimateArmor, "the_ultimate_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableCoalArmor, "coal_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableEmeraldArmor, "emerald_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableLapisArmor, "lapis_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableLavaArmor, "lava_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableObsidianArmor, "obsidian_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableRedstoneArmor, "redstone_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableChickenArmor, "chicken_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableSlimeArmor, "slime_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableArditeArmor, "ardite_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableCobaltArmor, "cobalt_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableManyullynArmor, "manyullyn_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enablePigIronArmor, "pig_iron_helmet");
        ModRecipes.addTOPRecipe(ModRecipes.gr.enableKnightSlimeArmor, "knight_slime_helmet");
    }

    private static void addTOPRecipe(boolean enabled, String name) {
        NBTTagCompound nbttagc = new NBTTagCompound();
        nbttagc.func_74768_a("theoneprobe", 1);
        Item helmet = Item.func_111206_d((String)("armorplus:" + name));
        if (helmet != null) {
            ItemStack stack = ItemStackUtils.getItemStack((Object)helmet);
            stack.func_77982_d(nbttagc);
            if (enabled && !stack.func_190926_b()) {
                GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL(name), (ResourceLocation)Utils.setRL("top"), (ItemStack)stack, (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)helmet), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((String)"theoneprobe", (String)"probe")})});
            }
        }
    }

    private static void addShapedRecipes() {
        if (!ModConfig.MainConfig.global.useJsonRecipes) {
            GameRegistry.addShapedRecipe((ResourceLocation)Utils.setRL("block_lava_crystal"), (ResourceLocation)Utils.setRL("lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaCrystal), (Object[])new Object[]{"CCC", "CCC", "CCC", Character.valueOf('C'), ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)0)});
            GameRegistry.addShapedRecipe((ResourceLocation)Utils.setRL("block_infused_lava_crystal"), (ResourceLocation)Utils.setRL("infused_lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockInfusedLavaCrystal), (Object[])new Object[]{"CCC", "CCC", "CCC", Character.valueOf('C'), ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1)});
            GameRegistry.addShapedRecipe((ResourceLocation)Utils.setRL("block_compressed_lava_crystal"), (ResourceLocation)Utils.setRL("compressed_lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedLavaCrystal), (Object[])new Object[]{"CCC", "CCC", "CCC", Character.valueOf('C'), ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaCrystal)});
            GameRegistry.addShapedRecipe((ResourceLocation)Utils.setRL("block_compressed_infused_lava_crystal"), (ResourceLocation)Utils.setRL("compressed_infused_lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedInfusedLavaCrystal), (Object[])new Object[]{"CCC", "CCC", "CCC", Character.valueOf('C'), ItemStackUtils.getItemStack((Object)ModBlocks.blockInfusedLavaCrystal)});
            GameRegistry.addShapedRecipe((ResourceLocation)Utils.setRL("workbench"), (ResourceLocation)Utils.setRL("benches"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.benches[0]), (Object[])new Object[]{"LCL", "OTO", "O O", Character.valueOf('T'), Blocks.field_150462_ai, Character.valueOf('O'), Blocks.field_150402_ci, Character.valueOf('L'), ItemStackUtils.getItemStack((Object)Items.field_151100_aR, (int)4), Character.valueOf('C'), ModItems.itemLavaCrystal});
            WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack((Block)ModBlocks.benches[0]), "LCL", "OTO", "O O", Character.valueOf('T'), Blocks.field_150462_ai, Character.valueOf('O'), Blocks.field_150402_ci, Character.valueOf('L'), ItemStackUtils.getItemStack((Object)Items.field_151100_aR, (int)4), Character.valueOf('C'), ModItems.itemLavaCrystal));
            if (ModConfig.RegistryConfig.recipes.enableElytraRecipe) {
                WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(Items.field_185160_cR, 1), "ESE", "SNS", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.materials, 1, 3), Character.valueOf('S'), Items.field_151007_F, Character.valueOf('N'), Items.field_151156_bN));
            }
            if (ModConfig.RegistryConfig.recipes.enableChainArmorRecipes) {
                WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151020_U, 1), "   ", "CCC", "C C", Character.valueOf('C'), "chainmail"));
                WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151020_U, 1), "CCC", "C C", "   ", Character.valueOf('C'), "chainmail"));
                WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151023_V, 1), "C C", "CCC", "CCC", Character.valueOf('C'), "chainmail"));
                WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151022_W, 1), "CCC", "C C", "C C", Character.valueOf('C'), "chainmail"));
                WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151029_X, 1), "   ", "C C", "C C", Character.valueOf('C'), "chainmail"));
                WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151029_X, 1), "C C", "C C", "   ", Character.valueOf('C'), "chainmail"));
            }
            WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)12, (int)0), "SS ", "S S", " SS", Character.valueOf('S'), "ingotIron"));
            WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedObsidian), "OOO", "OOO", "OOO", Character.valueOf('O'), "obsidian"));
            if (ModConfig.RegistryConfig.recipes.enableRedstoneAppleRecipes) {
                WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, ItemStackUtils.getItemStack((Object)ModItems.itemRedstoneApple), "RRR", "RAR", "RRR", Character.valueOf('R'), "dustRedstone", Character.valueOf('A'), Items.field_151034_e));
                WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, ItemStackUtils.getItemStack((Object)ModItems.itemRedstoneApple, (int)1), "BBB", "BAB", "BBB", Character.valueOf('B'), "blockRedstone", Character.valueOf('A'), Items.field_151034_e));
            }
            WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack((Block)ModBlocks.blockLavaNetherBrick, 4), " N ", "NLN", " N ", Character.valueOf('L'), Items.field_151129_at, Character.valueOf('N'), Blocks.field_150385_bj));
            IntStream.range(0, ModOreDicts.colors.length).forEachOrdered(i -> {
                ModRecipes.addRecipeCastle(ModBlocks.stoneBricks[i], ModOreDicts.colors[i]);
                ModRecipes.addRecipeCastleCorner((Block)ModBlocks.stoneBrickCorners[i], ModOreDicts.colors[i]);
                ModRecipes.addRecipeCastleTower(ModBlocks.stoneBrickTowers[i], ModOreDicts.colors[i]);
                ModRecipes.addRecipeCastleWall((Block)ModBlocks.stonebrickWalls[i], ModOreDicts.colors[i]);
                ModRecipes.addRecipeStoneBrick(ModOreDicts.colors[i]);
            });
        }
    }

    private static void addShapelessRecipes() {
        if (!ModConfig.MainConfig.global.useJsonRecipes) {
            GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("lava_crystal_from_block"), (ResourceLocation)Utils.setRL("lava_crystal"), (ItemStack)ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)9, (int)0), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaCrystal)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("infused_lava_crystal_from_block"), (ResourceLocation)Utils.setRL("infused_lava_crystal"), (ItemStack)ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)9, (int)1), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModBlocks.blockInfusedLavaCrystal)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("block_lava_crystal_from_compression"), (ResourceLocation)Utils.setRL("lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaCrystal, (int)9, (int)0), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedLavaCrystal)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("block_infused_lava_crystal_from_compression"), (ResourceLocation)Utils.setRL("infused_lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockInfusedLavaCrystal, (int)9, (int)0), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedInfusedLavaCrystal)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("obsidian_from_compression"), (ResourceLocation)Utils.setRL("obsidian"), (ItemStack)ItemStackUtils.getItemStack((Object)Blocks.field_150343_Z, (int)9, (int)0), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedObsidian)})});
        }
        GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("info_book"), (ResourceLocation)Utils.setRL("item_book"), (ItemStack)ItemStackUtils.getItemStack((Object)ModItems.bookInfo), (Ingredient[])new Ingredient[]{Ingredient.func_193368_a((Item[])new Item[]{Items.field_151122_aG}), Ingredient.func_193368_a((Item[])new Item[]{Items.field_151044_h})});
        GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("lava_cactus"), (ResourceLocation)Utils.setRL("lava_cactus"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaCactus, (int)1, (int)0), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)Blocks.field_150434_aF)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1)})});
    }

    private static void addRecipeCastleCorner(Block block, String color) {
        WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(block), "   ", "  S", " SS", Character.valueOf('S'), "stonebrick" + color));
        WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(block), "   ", "S  ", "SS ", Character.valueOf('S'), "stonebrick" + color));
        WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(block), "  S", " SS", "   ", Character.valueOf('S'), "stonebrick" + color));
        WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(block), "S  ", "SS ", "   ", Character.valueOf('S'), "stonebrick" + color));
    }

    private static void addRecipeCastleTower(Block block, String color) {
        WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(block), "   ", "S S", "SSS", Character.valueOf('S'), "stonebrick" + color));
        WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(block), "S S", "SSS", "   ", Character.valueOf('S'), "stonebrick" + color));
    }

    private static void addRecipeCastleWall(Block block, String color) {
        WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(block, 6), "   ", "SSS", "SSS", Character.valueOf('S'), "stonebrick" + color));
        WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(block, 6), "SSS", "SSS", "   ", Character.valueOf('S'), "stonebrick" + color));
    }

    private static void addRecipeCastle(Block block, String color) {
        WorkbenchRegistry.addRecipe(new BaseShapelessOreRecipe(new ItemStack(block, 3), "stonebrick" + color + "Corner"));
        WorkbenchRegistry.addRecipe(new BaseShapelessOreRecipe(new ItemStack(block, 5), "stonebrick" + color + "Tower"));
        WorkbenchRegistry.addRecipe(new BaseShapelessOreRecipe(new ItemStack(block), "stonebrick" + color + "Wall"));
        WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(block), " S ", "SCS", " S ", Character.valueOf('S'), "stonebrick", Character.valueOf('C'), "dye" + color));
    }

    private static void addRecipeStoneBrick(String color) {
        WorkbenchRegistry.addRecipe(new BaseShapelessOreRecipe(new ItemStack(Blocks.field_150417_aV), "stonebrick" + color));
    }
}

