/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.registry;

import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.iface.IModelHelper;
import net.thedragonteam.armorplus.util.Utils;

@SideOnly(value=Side.CLIENT)
public class ModModelUtils {
    public static void register(IModelHelper ... objects) {
        Arrays.stream(objects).forEachOrdered(IModelHelper::initModel);
    }

    public static void register(IModelHelper[] ... modelHelpers) {
        Arrays.stream(modelHelpers).forEachOrdered(ModModelUtils::register);
    }

    public static void register(boolean isEnabled, IModelHelper modelHolder) {
        if (isEnabled && Utils.isNotNull(modelHolder)) {
            ModModelUtils.register(modelHolder);
        }
    }

    public static void register(boolean isEnabled, IModelHelper ... modelHolders) {
        Arrays.stream(modelHolders).forEachOrdered(modelHolder -> ModModelUtils.register(isEnabled, modelHolder));
    }

    public static void register(boolean[] isEnabled, IModelHelper[] modelHolder) {
        IntStream.range(0, isEnabled.length).forEachOrdered(i -> ModModelUtils.register(isEnabled[i], modelHolder[i]));
    }

    public static void register(boolean[] isEnabled, IModelHelper[] ... armor) {
        IntStream.range(0, isEnabled.length).forEachOrdered(i -> ModModelUtils.register(isEnabled[i], armor[i]));
    }
}

