/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.proxy;

import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.command.ICommand;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.thedragonteam.armorplus.commands.CommandArmorPlus;
import net.thedragonteam.armorplus.compat.ICompatibility;
import net.thedragonteam.armorplus.compat.tinkers.TiC;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.entity.dungeon.guardianoverlord.EntityGuardianOverlord;
import net.thedragonteam.armorplus.entity.dungeon.guardianoverlord.projectile.EntityFreezeBomb;
import net.thedragonteam.armorplus.entity.dungeon.skeletalking.EntitySkeletalKing;
import net.thedragonteam.armorplus.entity.dungeon.skeletalking.projectile.EntityWitherMinion;
import net.thedragonteam.armorplus.registry.APItems;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModCompatibility;
import net.thedragonteam.armorplus.registry.ModEntities;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.registry.ModOreDicts;
import net.thedragonteam.armorplus.registry.ModRecipes;
import net.thedragonteam.armorplus.util.LoaderUtils;
import net.thedragonteam.armorplus.worldgen.OreGen;
import net.thedragonteam.armorplus.worldgen.nbt.StructureGenNBT;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        ModBlocks.registerBlocks();
        ModItems.registerItems();
        APItems.registerItemNames();
        APItems.registerWeaponsA();
        APItems.registerWeaponsB();
        this.registerEntityFixes();
        ModEntities.registerEntitySettings();
        this.registerWorldGenerator(new OreGen(), new StructureGenNBT());
        if (LoaderUtils.isTiCIntegrationEnabled()) {
            TiC.instance().preInit(event);
        }
        ModItems.registerTCItems();
        APItems.registerTCItemNames();
        ModCompatibility.registerModCompat();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.PRE_INIT);
        LogHelper.info((Object)"Finished PreInitialization");
    }

    private void registerEntityFixes() {
        EntityGuardianOverlord.registerFixesElderGuardian(DataFixesManager.func_188279_a());
        EntityFreezeBomb.registerFixesFreezeBomb(DataFixesManager.func_188279_a());
        EntitySkeletalKing.registerFixesSkeletalKing(DataFixesManager.func_188279_a());
        EntityWitherMinion.registerFixesWitherMinion(DataFixesManager.func_188279_a());
    }

    public void init(FMLInitializationEvent event) {
        ModOreDicts.registerOreDictEntries();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.INIT);
        ModRecipes.init();
        if (LoaderUtils.isTiCIntegrationEnabled()) {
            TiC.instance().init(event);
        }
        if (ModConfig.RegistryConfig.global_registry.enableArditeArmor) {
            Arrays.stream(ModItems.ardite).forEach(armor -> armor.setRepairStack(armor.field_77878_bZ.getRepairStack()));
        }
        if (ModConfig.RegistryConfig.global_registry.enableCobaltArmor) {
            Arrays.stream(ModItems.cobalt).forEach(armor -> armor.setRepairStack(armor.field_77878_bZ.getRepairStack()));
        }
        if (ModConfig.RegistryConfig.global_registry.enableManyullynArmor) {
            Arrays.stream(ModItems.manyullyn).forEach(armor -> armor.setRepairStack(armor.field_77878_bZ.getRepairStack()));
        }
        if (ModConfig.RegistryConfig.global_registry.enableKnightSlimeArmor) {
            Arrays.stream(ModItems.knightSlime).forEach(armor -> armor.setRepairStack(armor.field_77878_bZ.getRepairStack()));
        }
        if (ModConfig.RegistryConfig.global_registry.enablePigIronArmor) {
            Arrays.stream(ModItems.pigIron).forEach(armor -> armor.setRepairStack(armor.field_77878_bZ.getRepairStack()));
        }
        LogHelper.info((Object)"Finished Initialization");
    }

    public void postInit(FMLPostInitializationEvent event) {
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.POST_INIT);
        if (LoaderUtils.isTiCIntegrationEnabled()) {
            TiC.instance().postInit(event);
        }
        LogHelper.info((Object)"Finished PostInitialization");
    }

    public void modMapping(FMLModIdMappingEvent event) {
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.MAPPING);
    }

    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandArmorPlus());
    }

    private void registerWorldGenerator(IWorldGenerator ... generators) {
        IntStream.range(0, generators.length).forEachOrdered(i -> GameRegistry.registerWorldGenerator((IWorldGenerator)generators[i], (int)i));
    }
}

