/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.weapons;

import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.thedragonteam.armorplus.api.properties.iface.IDurable;
import net.thedragonteam.armorplus.api.properties.iface.IRemovable;
import net.thedragonteam.armorplus.api.properties.iface.IRepairable;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.registry.APItems;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public enum Bows implements IRepairable,
IRemovable,
IDurable
{
    COAL(ItemStackUtils.getItemStack((Object)Blocks.field_150402_ci), ModConfig.RegistryConfig.coal, APItems.coalBow, ModConfig.RegistryConfig.global_registry.enableCoalWeapons),
    LAPIS(ItemStackUtils.getItemStack((Object)Blocks.field_150368_y), ModConfig.RegistryConfig.lapis, APItems.lapisBow, ModConfig.RegistryConfig.global_registry.enableEmeraldWeapons),
    REDSTONE(ItemStackUtils.getItemStack((Object)Blocks.field_150451_bX), ModConfig.RegistryConfig.redstone, APItems.redstoneBow, ModConfig.RegistryConfig.global_registry.enableRedstoneWeapons),
    EMERALD(ItemStackUtils.getItemStack((Object)Blocks.field_150475_bE), ModConfig.RegistryConfig.emerald, APItems.emeraldBow, ModConfig.RegistryConfig.global_registry.enableEmeraldWeapons),
    OBSIDIAN(ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedObsidian), ModConfig.RegistryConfig.obsidian, APItems.obsidianBow, ModConfig.RegistryConfig.global_registry.enableObsidianWeapons),
    INFUSED_LAVA(ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1), ModConfig.RegistryConfig.lava, APItems.lavaBow, ModConfig.RegistryConfig.global_registry.enableLavaWeapons),
    GUARDIAN(ItemStackUtils.getItemStack((Object)ModItems.materials, (int)1), ModConfig.RegistryConfig.guardian, APItems.guardianBow, ModConfig.RegistryConfig.global_registry.enableGuardianWeapons),
    SUPER_STAR(ItemStackUtils.getItemStack((Object)ModItems.materials, (int)2), ModConfig.RegistryConfig.super_star, APItems.superStarBow, ModConfig.RegistryConfig.global_registry.enableSuperStarWeapons),
    ENDER_DRAGON(ItemStackUtils.getItemStack((Object)ModItems.materials, (int)3), ModConfig.RegistryConfig.ender_dragon, APItems.enderDragonBow, ModConfig.RegistryConfig.global_registry.enableEnderDragonWeapons);

    private final BowStats bowStats;
    private final boolean isEnabled;
    private final ItemStack repairStack;
    private final TextFormatting textFormatting;
    private final Item bowItem;

    private Bows(ItemStack repairStackIn, ModConfig.RegistryConfig.OriginMaterial material, Item bowItemIn, boolean[] isEnabled) {
        this.bowStats = new BowStats(material);
        this.isEnabled = isEnabled[2];
        if (repairStackIn == null) {
            repairStackIn = ItemStack.field_190927_a;
        }
        this.repairStack = repairStackIn;
        this.textFormatting = TextFormatting.func_96300_b((String)material.weapons.itemNameColor);
        this.bowItem = bowItemIn;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public double getDamage() {
        return this.bowStats.getBonusDamage();
    }

    @Override
    public int getDurability(boolean unbreakable) {
        return this.bowStats.getDurability();
    }

    public Item getBowItem() {
        return this.bowItem;
    }

    @Override
    public ItemStack getRepairStack() {
        return this.repairStack;
    }

    public TextFormatting getTextFormatting() {
        return this.textFormatting;
    }

    private static class BowStats {
        private final int durabilityIn;
        private final double bonusDamage;

        BowStats(ModConfig.RegistryConfig.OriginMaterial material) {
            this(material.weapons.bow.durability, material.weapons.bow.arrowBonusDamage);
        }

        private BowStats(int durability, double bonusDamage) {
            this.durabilityIn = durability;
            this.bonusDamage = bonusDamage;
        }

        double getBonusDamage() {
            return this.bonusDamage;
        }

        int getDurability() {
            return this.durabilityIn;
        }
    }
}

