/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.weapons;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.api.properties.AbilityCanceller;
import net.thedragonteam.armorplus.api.properties.AbilityProvider;
import net.thedragonteam.armorplus.api.properties.iface.IEffectHolder;
import net.thedragonteam.armorplus.api.properties.iface.IRemovable;
import net.thedragonteam.armorplus.api.properties.iface.IRepairable;
import net.thedragonteam.armorplus.client.utils.ToolTipUtils;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.items.base.ItemSpecialBattleAxe;
import net.thedragonteam.armorplus.items.weapons.effects.Ignite;
import net.thedragonteam.armorplus.items.weapons.effects.Negative;
import net.thedragonteam.armorplus.items.weapons.effects.WeaponEffects;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.util.ArmorPlusItemUtils;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public enum BattleAxes implements IEffectHolder,
IRemovable,
IRepairable
{
    COAL(ItemSpecialBattleAxe.battleAxeCoalMaterial, ItemStackUtils.getItemStack((Object)Blocks.field_150402_ci), ModConfig.RegistryConfig.coal, 8.0f, ModConfig.RegistryConfig.global_registry.enableCoalWeapons),
    LAPIS(ItemSpecialBattleAxe.battleAxeLapisMaterial, ItemStackUtils.getItemStack((Object)Blocks.field_150368_y), ModConfig.RegistryConfig.lapis, 9.0f, ModConfig.RegistryConfig.global_registry.enableLapisWeapons),
    REDSTONE(ItemSpecialBattleAxe.battleAxeRedstoneMaterial, ItemStackUtils.getItemStack((Object)Blocks.field_150451_bX), ModConfig.RegistryConfig.redstone, 9.0f, ModConfig.RegistryConfig.global_registry.enableRedstoneWeapons),
    EMERALD(ItemSpecialBattleAxe.battleAxeEmeraldMaterial, ItemStackUtils.getItemStack((Object)Blocks.field_150475_bE), ModConfig.RegistryConfig.emerald, 10.0f, ModConfig.RegistryConfig.global_registry.enableEmeraldWeapons),
    OBSIDIAN(ItemSpecialBattleAxe.battleAxeObsidianMaterial, ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedObsidian), ModConfig.RegistryConfig.obsidian, 10.5f, ModConfig.RegistryConfig.global_registry.enableObsidianWeapons),
    INFUSED_LAVA(ItemSpecialBattleAxe.battleAxeLavaMaterial, ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1), ModConfig.RegistryConfig.lava, 11.5f, ModConfig.RegistryConfig.global_registry.enableLavaWeapons),
    GUARDIAN(ItemSpecialBattleAxe.battleAxeGuardianMaterial, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)1), ModConfig.RegistryConfig.guardian, 14.0f, ModConfig.RegistryConfig.global_registry.enableGuardianWeapons),
    SUPER_STAR(ItemSpecialBattleAxe.battleAxeSuperStarMaterial, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)2), ModConfig.RegistryConfig.super_star, 15.0f, ModConfig.RegistryConfig.global_registry.enableSuperStarWeapons),
    ENDER_DRAGON(ItemSpecialBattleAxe.battleAxeEnderDragonMaterial, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)3), ModConfig.RegistryConfig.ender_dragon, 16.0f, ModConfig.RegistryConfig.global_registry.enableEnderDragonWeapons);

    private final Item.ToolMaterial material;
    private final ItemStack repairStack;
    private final TextFormatting textFormatting;
    private final boolean isEnabled;
    private final List<String> effect;
    private final float efficiency;
    private final Negative negative;
    private final Ignite ignite;

    private BattleAxes(Item.ToolMaterial materialIn, ItemStack repairStackIn, ModConfig.RegistryConfig.OriginMaterial material, float efficiencyIn, boolean[] isEnabled) {
        this.material = materialIn;
        this.repairStack = repairStackIn;
        this.textFormatting = TextFormatting.func_96300_b((String)material.weapons.itemNameColor);
        this.isEnabled = isEnabled[1];
        this.efficiency = efficiencyIn;
        WeaponEffects effects = new WeaponEffects(material);
        this.negative = effects.getNegative();
        this.ignite = effects.getIgnite();
        this.effect = BattleAxes.setToolTip(this.negative.getEffects(), this.negative.getEffectLevels());
    }

    @Override
    public AbilityProvider getApplicableAbilities() {
        return new AbilityProvider(this.negative.getEffects(), this.negative.getEffectLevels(), this.negative.getEffectDurations());
    }

    @Override
    public AbilityCanceller getRemovableAbilities() {
        return new AbilityCanceller();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static List<String> setToolTip(String[] effectName, int[] effectLevel) {
        return IntStream.range(0, effectLevel.length).mapToObj(i -> PotionUtils.localizePotion(effectName[i]) + " " + (effectLevel[i] + 1)).collect(Collectors.toList());
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public Item.ToolMaterial getToolMaterial() {
        return this.material;
    }

    public List<String> getEffects() {
        return this.effect;
    }

    @Override
    public ItemStack getRepairStack() {
        return this.repairStack;
    }

    public TextFormatting getTextFormatting() {
        return this.textFormatting;
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        if (this.ignite.isEnabled()) {
            target.func_70015_d(this.ignite.getFireSeconds());
        }
        ArmorPlusItemUtils.applyNegativeEffect(target, this.negative);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> tooltip) {
        ToolTipUtils.addSpecialInformation(tooltip, this.negative, this.ignite, this.getTextFormatting());
    }
}

