/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.dev;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.DevUtils;
import net.thedragonteam.armorplus.client.utils.ToolTipUtils;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.items.base.ItemBase;
import net.thedragonteam.armorplus.util.JsonUtils;
import net.thedragonteam.armorplus.util.Utils;

public class ItemDevTool
extends ItemBase {
    public ItemDevTool() {
        super("dev_tool");
        this.func_77637_a(ArmorPlus.tabArmorplusItems);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.getRarity("DEV", TextFormatting.BOLD, "Dev");
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if ((DevUtils.enableDevTool() || ModConfig.DebugConfig.debugMode) && !playerIn.field_70170_p.field_72995_K && Utils.isNotNull(target)) {
            this.writeFile(playerIn, target);
            return true;
        }
        return false;
    }

    private void writeFile(EntityPlayer player, EntityLivingBase entity) {
        new File("./armorplus/entity/" + player.func_110124_au()).mkdirs();
        LocalDateTime dateTime = LocalDateTime.now();
        String timeStamp = dateTime.getHour() + "-" + dateTime.getMinute() + "-" + dateTime.getSecond() + "-" + dateTime.getYear() + "-" + dateTime.getMonth().getValue() + "-" + dateTime.getDayOfMonth();
        try (FileWriter fileWriter = new FileWriter(new File(String.format("./armorplus/entity/%s/%s_%s.json", player.func_110124_au(), entity.func_70005_c_(), timeStamp)));){
            WorldInfo worldInfo = entity.field_70170_p.func_72912_H();
            BlockPos entityPos = entity.func_180425_c();
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("entity_class", JsonUtils.getPrimitive(entity.getClass().getName()));
            HashMap<String, JsonElement> nameMap = new HashMap<String, JsonElement>();
            nameMap.put("name", JsonUtils.getPrimitive(entity.func_70005_c_()));
            nameMap.put("custom_name_tag", JsonUtils.getPrimitive(entity.func_95999_t()));
            jsonObject.add("names", (JsonElement)JsonUtils.addArray(nameMap));
            jsonObject.add("dimension", (JsonElement)JsonUtils.addArray("id", JsonUtils.getPrimitive(entity.field_71093_bK)));
            HashMap<String, JsonElement> worldMap = new HashMap<String, JsonElement>();
            worldMap.put("name", JsonUtils.getPrimitive(worldInfo.func_76065_j()));
            worldMap.put("are_commands_allowed", JsonUtils.getPrimitive(worldInfo.func_76086_u()));
            worldMap.put("is_difficulty_locked", JsonUtils.getPrimitive(worldInfo.func_176123_z()));
            worldMap.put("is_hardcore_mode_enabled", JsonUtils.getPrimitive(worldInfo.func_76093_s()));
            HashMap<String, JsonElement> worldSpawnMap = new HashMap<String, JsonElement>();
            worldSpawnMap.put("x", JsonUtils.getPrimitive(worldInfo.func_76079_c()));
            worldSpawnMap.put("y", JsonUtils.getPrimitive(worldInfo.func_76075_d()));
            worldSpawnMap.put("z", JsonUtils.getPrimitive(worldInfo.func_76074_e()));
            worldMap.put("spawn", (JsonElement)JsonUtils.addArray(worldSpawnMap));
            jsonObject.add("world", (JsonElement)JsonUtils.addArray(JsonUtils.addProperty(worldMap)));
            HashMap<String, JsonElement> entityPosMap = new HashMap<String, JsonElement>();
            entityPosMap.put("x", JsonUtils.getPrimitive(entityPos.func_177958_n()));
            entityPosMap.put("y", JsonUtils.getPrimitive(entityPos.func_177956_o()));
            entityPosMap.put("z", JsonUtils.getPrimitive(entityPos.func_177952_p()));
            jsonObject.add("position", (JsonElement)JsonUtils.addArray(entityPosMap));
            HashMap<String, JsonElement> inventoryArmorMap = new HashMap<String, JsonElement>();
            inventoryArmorMap.put("head", (JsonElement)this.addArmorItemData(entity, EntityEquipmentSlot.HEAD));
            inventoryArmorMap.put("chest", (JsonElement)this.addArmorItemData(entity, EntityEquipmentSlot.CHEST));
            inventoryArmorMap.put("legs", (JsonElement)this.addArmorItemData(entity, EntityEquipmentSlot.LEGS));
            inventoryArmorMap.put("feet", (JsonElement)this.addArmorItemData(entity, EntityEquipmentSlot.FEET));
            jsonObject.add("inventory_armor", (JsonElement)JsonUtils.addArray(inventoryArmorMap));
            HashMap<String, JsonElement> inventoryHandsMap = new HashMap<String, JsonElement>();
            inventoryHandsMap.put("main_hand", (JsonElement)this.addItemData(entity.func_184614_ca()));
            inventoryHandsMap.put("off_hand", (JsonElement)this.addItemData(entity.func_184592_cb()));
            jsonObject.add("inventory_hands", (JsonElement)JsonUtils.addArray(inventoryHandsMap));
            HashMap<String, JsonElement> entityInfoMap = new HashMap<String, JsonElement>();
            entityInfoMap.put("max_health", JsonUtils.getPrimitive(Float.valueOf(entity.func_110138_aP())));
            entityInfoMap.put("health", JsonUtils.getPrimitive(Float.valueOf(entity.func_110143_aJ())));
            entityInfoMap.put("absorption_amount", JsonUtils.getPrimitive(Float.valueOf(entity.func_110139_bj())));
            entityInfoMap.put("is_invulnerable", JsonUtils.getPrimitive(entity.func_190530_aW()));
            entityInfoMap.put("is_invisible", JsonUtils.getPrimitive(entity.func_82150_aj()));
            entityInfoMap.put("is_glowing", JsonUtils.getPrimitive(entity.func_184202_aL()));
            entityInfoMap.put("is_immune_to_explosions", JsonUtils.getPrimitive(entity.func_180427_aV()));
            entityInfoMap.put("is_immune_to_fire", JsonUtils.getPrimitive(entity.func_70045_F()));
            jsonObject.add("entity_info", (JsonElement)JsonUtils.addArray(entityInfoMap));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String jsonString = gson.toJson((JsonElement)jsonObject);
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JsonArray addArmorItemData(EntityLivingBase entity, EntityEquipmentSlot slot) {
        return this.addItemData(entity.func_184582_a(slot));
    }

    private JsonArray addItemData(ItemStack stack) {
        HashMap<String, JsonElement> itemDataMap = new HashMap<String, JsonElement>();
        if (!stack.func_190926_b()) {
            itemDataMap.put("itemstack", JsonUtils.getPrimitive(stack.func_77973_b().getRegistryName()));
            itemDataMap.put("display_name", JsonUtils.getPrimitive(stack.func_82833_r()));
            itemDataMap.put("unlocalized_name", JsonUtils.getPrimitive(stack.func_77977_a()));
            itemDataMap.put("count", JsonUtils.getPrimitive(stack.func_190916_E()));
            itemDataMap.put("metadata", JsonUtils.getPrimitive(stack.func_77960_j()));
        }
        return JsonUtils.addArray(itemDataMap);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add("\u00a7cOnly works if debugMode = true in the configuration file");
            tooltip.add("\u00c2\u00a79Ability: \u00c2\u00a7rGives Information about the Target");
            tooltip.add("\u00c2\u00a73Use: \u00c2\u00a7rRight Click a Target");
            if (advanced.func_194127_a()) {
                tooltip.add("Information is located at: <instance>/armorplus/<player_name>/<entity>-<id>-<date>");
            }
        } else {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, TextFormatting.BOLD);
        }
    }
}

