/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.arrows;

import java.util.List;
import java.util.Locale;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.entity.entityarrow.EntityCoalArrow;
import net.thedragonteam.armorplus.entity.entityarrow.EntityEnderDragonArrow;
import net.thedragonteam.armorplus.entity.entityarrow.EntityLapisArrow;
import net.thedragonteam.armorplus.entity.entityarrow.EntityLavaArrow;
import net.thedragonteam.armorplus.entity.entityarrow.EntityModdedArrow;
import net.thedragonteam.armorplus.entity.entityarrow.EntityRedstoneArrow;
import net.thedragonteam.armorplus.util.ArrowUtils;

public enum ArrowType {
    COAL("Applies Blindness", 2.0, TextFormatting.GRAY){

        @Override
        public EntityModdedArrow createArrow(World world, EntityLivingBase shooter) {
            return new EntityCoalArrow(world, shooter);
        }
    }
    ,
    LAPIS("Applies Nausea", 3.5, TextFormatting.DARK_AQUA){

        @Override
        public EntityModdedArrow createArrow(World world, EntityLivingBase shooter) {
            return new EntityLapisArrow(world, shooter);
        }
    }
    ,
    REDSTONE("Applies Slowness", 3.5, TextFormatting.DARK_RED){

        @Override
        public EntityModdedArrow createArrow(World world, EntityLivingBase shooter) {
            return new EntityRedstoneArrow(world, shooter);
        }
    }
    ,
    INFUSED_LAVA("Sets on Fire", 5.5, TextFormatting.GOLD){

        @Override
        public EntityModdedArrow createArrow(World world, EntityLivingBase shooter) {
            return new EntityLavaArrow(world, shooter);
        }
    }
    ,
    ENDER_DRAGON("Applies Wither 4", 8.5, TextFormatting.DARK_PURPLE){

        @Override
        public EntityModdedArrow createArrow(World world, EntityLivingBase shooter) {
            return new EntityEnderDragonArrow(world, shooter);
        }
    };

    private final String abilityDescription;
    private final double damage;
    private final TextFormatting formatting;

    private ArrowType(String abilityDescription, double damage, TextFormatting formatting) {
        this.abilityDescription = abilityDescription;
        this.damage = damage;
        this.formatting = formatting;
    }

    public String getAbilityDescription() {
        return this.abilityDescription;
    }

    public double getDamage() {
        return this.damage;
    }

    public TextFormatting getFormatting() {
        return this.formatting;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getItemArrowName() {
        return this.getName() + "_arrow";
    }

    public abstract EntityModdedArrow createArrow(World var1, EntityLivingBase var2);

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> tooltip) {
        ArrowUtils.addArrowInformation(tooltip, this.getAbilityDescription(), this.getDamage(), this.getFormatting());
    }
}

