/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.events;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.blocks.base.BlockBase;
import net.thedragonteam.armorplus.blocks.benches.BlockBench;
import net.thedragonteam.armorplus.blocks.benches.ItemBlockBench;
import net.thedragonteam.armorplus.blocks.dungeon.ItemDungeonBlock;
import net.thedragonteam.armorplus.enchantments.FuriousEnchantment;
import net.thedragonteam.armorplus.enchantments.LifeStealEnchantment;
import net.thedragonteam.armorplus.entity.dungeon.guardianoverlord.EntityGuardianOverlord;
import net.thedragonteam.armorplus.entity.dungeon.guardianoverlord.projectile.EntityFreezeBomb;
import net.thedragonteam.armorplus.entity.dungeon.skeletalking.EntitySkeletalKing;
import net.thedragonteam.armorplus.entity.dungeon.skeletalking.projectile.EntityWitherMinion;
import net.thedragonteam.armorplus.entity.entityarrow.EntityCoalArrow;
import net.thedragonteam.armorplus.entity.entityarrow.EntityEnderDragonArrow;
import net.thedragonteam.armorplus.entity.entityarrow.EntityLapisArrow;
import net.thedragonteam.armorplus.entity.entityarrow.EntityLavaArrow;
import net.thedragonteam.armorplus.entity.entityarrow.EntityRedstoneArrow;
import net.thedragonteam.armorplus.entity.mobs.EntityEnderDragonZombie;
import net.thedragonteam.armorplus.entity.mobs.EntityIceGolem;
import net.thedragonteam.armorplus.items.materials.ItemRename;
import net.thedragonteam.armorplus.potions.PotionEmpty;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.sounds.SoundTrapTriggered;
import net.thedragonteam.armorplus.tileentity.TileCB;
import net.thedragonteam.armorplus.tileentity.TileHTB;
import net.thedragonteam.armorplus.tileentity.TileLavaInfuser;
import net.thedragonteam.armorplus.tileentity.TileTrophy;
import net.thedragonteam.armorplus.tileentity.TileUTB;
import net.thedragonteam.armorplus.tileentity.TileWB;
import net.thedragonteam.armorplus.util.Utils;

@Mod.EventBusSubscriber(modid="armorplus")
public class RegistryEventHandler {
    public static final int DATA_FIXER_VERSION = 132;

    @SubscribeEvent
    public static void registerMappings(RegistryEvent.MissingMappings<Item> e) {
        RegistryEventHandler.registerItemFixes();
    }

    private static void registerEntities(Class<? extends Entity> entityClass, String registryName, int id, int trackingRange, int updateFrequency, boolean sendVelocityUpdates, boolean hasEgg, int primaryColor, int secondaryColor) {
        ResourceLocation resourceLocation = Utils.setRL(registryName);
        if (hasEgg) {
            EntityRegistry.registerModEntity((ResourceLocation)resourceLocation, entityClass, (String)registryName, (int)id, (Object)ArmorPlus.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocityUpdates, (int)primaryColor, (int)secondaryColor);
        } else {
            EntityRegistry.registerModEntity((ResourceLocation)resourceLocation, entityClass, (String)registryName, (int)id, (Object)ArmorPlus.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocityUpdates);
        }
    }

    private static void registerEntities(Class<? extends Entity> entityClass, String registryName, int id, int primaryColor, int secondaryColor) {
        RegistryEventHandler.registerEntities(entityClass, registryName, id, 64, 1, true, true, primaryColor, secondaryColor);
    }

    private static void registerEntities(Class<? extends Entity> entityClass, String registryName, int id) {
        RegistryEventHandler.registerEntities(entityClass, registryName, id, 64, 1, true, false, 0, 0);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        int id = 0;
        RegistryEventHandler.registerEntities(EntityCoalArrow.class, "coal_arrow", ++id);
        RegistryEventHandler.registerEntities(EntityLapisArrow.class, "lapis_arrow", ++id);
        RegistryEventHandler.registerEntities(EntityRedstoneArrow.class, "redstone_arrow", ++id);
        RegistryEventHandler.registerEntities(EntityLavaArrow.class, "lava_arrow", ++id);
        RegistryEventHandler.registerEntities(EntityEnderDragonArrow.class, "ender_dragon_arrow", ++id);
        RegistryEventHandler.registerEntities(EntityFreezeBomb.class, "freeze_bomb", ++id);
        RegistryEventHandler.registerEntities(EntityWitherMinion.class, "wither_minion", ++id);
        RegistryEventHandler.registerEntities(EntityEnderDragonZombie.class, "ender_dragon_zombie", ++id, 7475556, 65280);
        RegistryEventHandler.registerEntities(EntityIceGolem.class, "ice_golem", ++id, 0xFFFFFF, 65280);
        RegistryEventHandler.registerEntities(EntityGuardianOverlord.class, "overlord_of_the_guardians", ++id, 8054015, 7972607);
        RegistryEventHandler.registerEntities(EntitySkeletalKing.class, "skeletal_king", ++id, 6708050, 8673331);
    }

    private static void registerAllBlocks(RegistryEvent.Register<Block> event, Block[] ... blocksArray) {
        Arrays.stream(blocksArray).forEachOrdered(blockList -> RegistryEventHandler.registerAllBlocks(event, blockList));
    }

    private static void registerAllBlocks(RegistryEvent.Register<Block> event, Block ... blockList) {
        Arrays.stream(blockList).filter(Utils::isNotNull).forEachOrdered(block -> event.getRegistry().register((IForgeRegistryEntry)block));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryEventHandler.registerAllBlocks(event, (Block[])ModBlocks.benches);
        RegistryEventHandler.registerAllBlocks(event, new Block[]{ModBlocks.blockCrystalOre, ModBlocks.blockCompressedObsidian, ModBlocks.steelBlock, ModBlocks.electricalBlock, ModBlocks.blockLavaNetherBrick, ModBlocks.blockLavaCactus, ModBlocks.lavaInfuser, ModBlocks.lavaInfuserInfusing, ModBlocks.blockLavaInfusedObsidian, ModBlocks.blockLavaCrystal, ModBlocks.blockInfusedLavaCrystal, ModBlocks.blockCompressedLavaCrystal, ModBlocks.blockCompressedInfusedLavaCrystal});
        RegistryEventHandler.registerAllBlocks(event, new Block[][]{ModBlocks.stoneBricks, ModBlocks.stoneBrickTowers, ModBlocks.stoneBrickCorners, ModBlocks.stonebrickWalls});
        RegistryEventHandler.registerAllBlocks(event, (Block[])ModBlocks.enderBlocks);
        RegistryEventHandler.registerAllBlocks(event, (Block[])ModBlocks.trophies);
        RegistryEventHandler.registerTileEntities();
        RegistryEventHandler.registerTEFixes();
    }

    private static void registerTEFixes() {
        CompoundDataFixer dataFixer = FMLCommonHandler.instance().getDataFixer();
        TileLavaInfuser.registerFixesLavaInfuser((DataFixer)dataFixer);
        TileWB.registerWBFixes((DataFixer)dataFixer);
        TileHTB.registerHTBFixes((DataFixer)dataFixer);
        TileUTB.registerUTBFixes((DataFixer)dataFixer);
        TileCB.registerCBFixes((DataFixer)dataFixer);
        TileTrophy.registerTrophyFixes((DataFixer)dataFixer);
    }

    private static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileLavaInfuser.class, (ResourceLocation)Utils.setRL("lava_infuser_tile_entity"));
        GameRegistry.registerTileEntity(TileWB.class, (ResourceLocation)Utils.setRL("workbench_tile_entity"));
        GameRegistry.registerTileEntity(TileHTB.class, (ResourceLocation)Utils.setRL("high_tech_bench_tile_entity"));
        GameRegistry.registerTileEntity(TileUTB.class, (ResourceLocation)Utils.setRL("ulti_tech_tile_entity"));
        GameRegistry.registerTileEntity(TileCB.class, (ResourceLocation)Utils.setRL("champion_tile_entity"));
        GameRegistry.registerTileEntity(TileTrophy.class, (ResourceLocation)Utils.setRL("trophy_tile_entity"));
    }

    private static void registerItemBlock(RegistryEvent.Register<Item> event, Block ... blocks) {
        Arrays.stream(blocks).forEachOrdered(block -> {
            if (Utils.areNotNull(block, block.getRegistryName())) {
                ItemBlock itemBlock = new ItemBlock(block);
                itemBlock.setRegistryName(block.getRegistryName());
                event.getRegistry().register((IForgeRegistryEntry)itemBlock);
            }
        });
    }

    private static void registerDungeonBlock(RegistryEvent.Register<Item> event, BlockBase ... blocks) {
        Arrays.stream(blocks).forEachOrdered(block -> {
            if (Utils.areNotNull(block, block.getRegistryName())) {
                ItemDungeonBlock itemBlock = new ItemDungeonBlock((BlockBase)((Object)block));
                event.getRegistry().register((IForgeRegistryEntry)itemBlock);
            }
        });
    }

    private static void registerBenchBlocks(RegistryEvent.Register<Item> event, BlockBench ... blocks) {
        Arrays.stream(blocks).forEachOrdered(block -> {
            if (Utils.areNotNull(block, block.getRegistryName())) {
                ItemBlockBench itemBlock = new ItemBlockBench((BlockBench)block);
                event.getRegistry().register((IForgeRegistryEntry)itemBlock);
            }
        });
    }

    private static void registerAllItemBlocks(RegistryEvent.Register<Item> event, Block[] ... blockArray) {
        Arrays.stream(blockArray).forEachOrdered(blockList -> RegistryEventHandler.registerItemBlock(event, blockList));
    }

    private static void registerAllItems(RegistryEvent.Register<Item> event, Item[] ... itemsArray) {
        Arrays.stream(itemsArray).forEachOrdered(itemList -> RegistryEventHandler.registerAllItems(event, itemList));
    }

    private static void registerAllItems(RegistryEvent.Register<Item> event, Item ... itemsArray) {
        Arrays.stream(itemsArray).filter(Utils::isNotNull).forEachOrdered(anItemsArray -> event.getRegistry().register((IForgeRegistryEntry)anItemsArray));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        RegistryEventHandler.registerBenchBlocks(event, ModBlocks.benches);
        RegistryEventHandler.registerItemBlock(event, new Block[]{ModBlocks.blockCrystalOre, ModBlocks.blockCompressedObsidian, ModBlocks.steelBlock, ModBlocks.electricalBlock, ModBlocks.blockLavaNetherBrick, ModBlocks.blockLavaCactus, ModBlocks.lavaInfuser, ModBlocks.lavaInfuserInfusing, ModBlocks.blockLavaInfusedObsidian, ModBlocks.blockLavaCrystal, ModBlocks.blockInfusedLavaCrystal, ModBlocks.blockCompressedLavaCrystal, ModBlocks.blockCompressedInfusedLavaCrystal});
        RegistryEventHandler.registerAllItemBlocks(event, new Block[][]{ModBlocks.stoneBricks, ModBlocks.stoneBrickTowers, ModBlocks.stoneBrickCorners, ModBlocks.stonebrickWalls});
        RegistryEventHandler.registerDungeonBlock(event, ModBlocks.enderBlocks);
        RegistryEventHandler.registerAllItemBlocks(event, new Block[][]{ModBlocks.trophies});
        RegistryEventHandler.registerAllItems(event, new Item[]{ModItems.bookInfo, ModItems.steelIngot, ModItems.electricalIngot, ModItems.itemRedstoneApple, ModItems.itemLavaCrystal, ModItems.itemTGOTG, ModItems.itemDevTool, ModItems.theUltimateParts, ModItems.itemCoalArrow, ModItems.itemLapisArrow, ModItems.itemRedstoneArrow, ModItems.itemLavaArrow, ModItems.itemEnderDragonArrow});
        RegistryEventHandler.registerAllItems(event, ModItems.materials);
        RegistryEventHandler.registerAllItems(event, ModItems.towerSpawnItem);
        RegistryEventHandler.registerItemFixes();
        RegistryEventHandler.registerAllItems(event, ModItems.twitchItem, ModItems.beamItem, ModItems.theDragonTeamItem, ModItems.moddedCityItem, ModItems.jonBamsItem, ModItems.btmMoon, ModItems.m1Jordan, ModItems.teamRapture);
        RegistryEventHandler.registerAllItems(event, new Item[][]{ModItems.coal, ModItems.emerald, ModItems.lapis, ModItems.lava, ModItems.obsidian, ModItems.redstone, ModItems.chicken, ModItems.slime, ModItems.guardian, ModItems.superStar, ModItems.enderDragon, ModItems.theUltimate, ModItems.ardite, ModItems.cobalt, ModItems.manyullyn, ModItems.pigIron, ModItems.knightSlime});
        RegistryEventHandler.registerAllItems(event, (Item[])ModItems.horseArmors);
        RegistryEventHandler.registerAllItems(event, new Item[][]{ModItems.sword, ModItems.battleAxe, ModItems.bow});
    }

    public static void registerItemFixes() {
        ModFixs modFixs = new CompoundDataFixer((DataFixer)FMLCommonHandler.instance().getDataFixer()).init("armorplus", 132);
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new ItemRename());
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{new FuriousEnchantment(), new LifeStealEnchantment()});
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)new PotionEmpty());
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)new SoundTrapTriggered());
    }
}

