/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.events;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.entity.dungeon.skeletalking.EntitySkeletalKing;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;
import net.thedragonteam.thedragonlib.util.LogHelper;

@Mod.EventBusSubscriber(modid="armorplus")
public class MobDropsEventHandler {
    private static Random random = new Random();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        int min = 0;
        int max = 1;
        int randomDrop = random.nextInt(max - min + 1) + min;
        Entity entity = event.getEntity();
        if (entity instanceof EntityDragon) {
            MobDropsEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.ender_dragon_scale.drop, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)ModConfig.EntitiesConfig.mob_drops.ender_dragon_scale.dropAmount, (int)3));
            MobDropsEventHandler.registerTrophyDrop(event, 3);
        }
        if (entity instanceof EntityWither) {
            MobDropsEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.wither_bone.bossDrop, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)ModConfig.EntitiesConfig.mob_drops.wither_bone.dropAmount, (int)2));
            MobDropsEventHandler.registerTrophyDrop(event, 2);
        }
        if (entity instanceof EntityWitherSkeleton) {
            MobDropsEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.wither_bone.witherSkeletonDrop, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)randomDrop, (int)2));
        }
        if (entity instanceof EntityGuardian) {
            MobDropsEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.guardian_scale.guardianDrop, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)randomDrop, (int)1));
        }
        if (entity instanceof EntityElderGuardian) {
            MobDropsEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.guardian_scale.elderDrop, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)ModConfig.EntitiesConfig.mob_drops.guardian_scale.dropAmount, (int)1));
            MobDropsEventHandler.registerTrophyDrop(event, 1);
        }
        if (entity instanceof EntitySkeletalKing) {
            MobDropsEventHandler.registerTrophyDrop(event, 4);
        }
    }

    private static void registerTrophyDrop(LivingDropsEvent event, int trophy) {
        MobDropsEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.trophy.enableTrophyDrops, ItemStackUtils.getItemStack((Object)ModBlocks.trophies[trophy]));
    }

    private static void registerMobDrop(LivingDropsEvent event, boolean enableDrop, ItemStack drop) {
        if (enableDrop) {
            event.getEntityLiving().func_70099_a(drop, 0.0f);
            if (ModConfig.DebugConfig.debugMode) {
                LogHelper.info((Object)(event.getEntity().func_70005_c_() + " dropped:" + drop + " x " + drop.func_190916_E()));
            }
        }
    }
}

