/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.entity.dungeon.skeletalking;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.thedragonteam.armorplus.entity.dungeon.base.BossInfoServerDungeon;
import net.thedragonteam.armorplus.entity.dungeon.base.EntityAIRangedDungeonAttack;
import net.thedragonteam.armorplus.entity.dungeon.skeletalking.projectile.EntityWitherMinion;

public class EntitySkeletalKing
extends EntityWitherSkeleton
implements IRangedAttackMob {
    private static final Predicate<Entity> PLAYER = target -> target instanceof EntityPlayer && ((EntityLivingBase)target).func_190631_cK();
    private final BossInfoServerDungeon bossInfo;
    private List<EntityPlayer> playersReadDialog = new ArrayList<EntityPlayer>();
    private List<EntityPlayer> playersReadDeathDialog = new ArrayList<EntityPlayer>();
    private int sendDialog = 0;
    private boolean sentA;
    private boolean sentB;
    private boolean sentC;
    private boolean sentD;
    private boolean sentE;
    private boolean sentF;
    private boolean sentEnd;

    public EntitySkeletalKing(World worldIn) {
        super(worldIn);
        this.func_70105_a(this.field_70130_N * 7.0f, this.field_70131_O * 7.0f);
        this.bossInfo = new BossInfoServerDungeon(this.func_145748_c_(), BossInfoServerDungeon.BossInfoDungeonType.SKELETAL_KING);
        this.func_110163_bv();
        this.field_70178_ae = true;
    }

    public static void registerFixesSkeletalKing(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntitySkeletalKing.class);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        if (!this.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
            this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public void func_70071_h_() {
        this.func_184589_d(MobEffects.field_82731_v);
        super.func_70071_h_();
        EntityPlayer playerInRange = this.field_70170_p.func_72890_a((Entity)this, 150.0);
        ++this.sendDialog;
        if (this.field_70170_p.field_72995_K || playerInRange == null) {
            return;
        }
        if (!this.playersReadDialog.contains(playerInRange) && this.sendDialog % 120 == 0) {
            if (this.checkPhase(1200.0f)) {
                if (!this.sentA) {
                    playerInRange.func_145747_a((ITextComponent)new TextComponentTranslation(String.format("%s%sSkeletal King:\n%sHa ha ha!\n%sYou really think you even want to get me started with you?\n%sThis fight will be over way before it even starts.", TextFormatting.GOLD, TextFormatting.BOLD, TextFormatting.ITALIC, TextFormatting.ITALIC, TextFormatting.ITALIC), new Object[0]));
                    this.sentA = true;
                }
            } else if (this.checkPhase(1000.0f)) {
                if (!this.sentB) {
                    playerInRange.func_145747_a((ITextComponent)new TextComponentTranslation(String.format("%s%sSkeletal King:\n%sThat's just the beginning.", TextFormatting.GOLD, TextFormatting.BOLD, TextFormatting.ITALIC), new Object[0]));
                    this.sentB = true;
                }
            } else if (this.checkPhase(800.0f)) {
                if (!this.sentC) {
                    playerInRange.func_145747_a((ITextComponent)new TextComponentTranslation(String.format("%s%sSkeletal King:\n%sIt seems that you are enjoying my minions...\n%sWell, I got some news to you.\n%sI own this world", TextFormatting.GOLD, TextFormatting.BOLD, TextFormatting.ITALIC, TextFormatting.ITALIC, TextFormatting.ITALIC), new Object[0]));
                    this.sentC = true;
                }
            } else if (this.checkPhase(600.0f)) {
                if (!this.sentD) {
                    playerInRange.func_145747_a((ITextComponent)new TextComponentTranslation(String.format("%s%sSkeletal King:\n%sWhy do you keep fighting\n%sThere is no escape from me!", TextFormatting.GOLD, TextFormatting.BOLD, TextFormatting.ITALIC, TextFormatting.ITALIC), new Object[0]));
                    this.sentD = true;
                }
            } else if (this.checkPhase(400.0f)) {
                if (!this.sentE) {
                    playerInRange.func_145747_a((ITextComponent)new TextComponentTranslation(String.format("%s%sSkeletal King:\n%sWHY CAN'T YOU JUST DIE!?\n%sPaladins, Rise!", TextFormatting.GOLD, TextFormatting.BOLD, TextFormatting.ITALIC, TextFormatting.ITALIC), new Object[0]));
                    this.sentE = true;
                }
            } else if (this.checkPhase(200.0f)) {
                if (!this.sentF) {
                    playerInRange.func_145747_a((ITextComponent)new TextComponentTranslation(String.format("%s%sSkeletal King:\n%sNothing can stop me from destroying this world\n%sIf my minions, cannot kill you. then I'll kill you myself!\n%sMinions, CHARGE with your full power!!!", TextFormatting.GOLD, TextFormatting.BOLD, TextFormatting.ITALIC, TextFormatting.ITALIC, TextFormatting.ITALIC), new Object[0]));
                    this.sentF = true;
                }
            } else if (this.field_70128_L && this.sentEnd) {
                playerInRange.func_145747_a((ITextComponent)new TextComponentTranslation(String.format("%s%sSkeletal King:\n%sYou cannot win this battle, " + playerInRange.func_70005_c_() + "\n%sThe end is near, but remember I'll be BACK \n%sAnd there will be an END to this world.", TextFormatting.GOLD, TextFormatting.BOLD, TextFormatting.ITALIC, TextFormatting.ITALIC, TextFormatting.ITALIC), new Object[0]));
                this.sentEnd = true;
                this.playersReadDialog.add(playerInRange);
            }
        }
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        EntityPlayer playerInRange = this.field_70170_p.func_72890_a((Entity)this, 150.0);
        if (this.field_70170_p.field_72995_K || playerInRange == null) {
            return;
        }
        if (!this.playersReadDeathDialog.contains(playerInRange) && this.sendDialog % 120 == 0) {
            playerInRange.func_145747_a((ITextComponent)new TextComponentTranslation(String.format("%s%sSkeletal King:\n%sYou cannot win this battle, " + playerInRange.func_70005_c_() + "\n%sThe end is near, but remember I'll be BACK \n%sAnd there will be an END to this world.", TextFormatting.GOLD, TextFormatting.BOLD, TextFormatting.ITALIC, TextFormatting.ITALIC, TextFormatting.ITALIC), new Object[0]));
            this.playersReadDeathDialog.add(playerInRange);
        }
    }

    private boolean checkPhase(float phase) {
        float health = this.func_110143_aJ();
        return health <= phase && health > phase - 200.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRangedDungeonAttack(this, EntityAIRangedDungeonAttack.EntityAIType.WITHER));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 20.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, false, PLAYER));
        super.func_184651_r();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.6f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public Iterable<ItemStack> func_184209_aF() {
        return Collections.emptyList();
    }

    public Iterable<ItemStack> func_184214_aD() {
        return Collections.emptyList();
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private void launchWitherMinionsToEntity(int pos, EntityLivingBase entity) {
        this.launchWitherMinions(pos, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() * 0.5, entity.field_70161_v);
    }

    private void launchWitherMinions(int pos, double x, double y, double z) {
        this.field_70170_p.func_180498_a(null, 1024, new BlockPos((Entity)this), 0);
        double headingX = this.getHeadX(pos);
        double headingY = this.getHeadY(pos);
        double headingZ = this.getHeadZ(pos);
        double estimatedX = x - headingX;
        double estimatedY = y - headingY;
        double estimatedZ = z - headingZ;
        EntityWitherMinion witherMinion = new EntityWitherMinion(this.field_70170_p, (EntityLivingBase)this, estimatedX, estimatedY, estimatedZ);
        witherMinion.field_70163_u = headingY;
        witherMinion.field_70165_t = headingX;
        witherMinion.field_70161_v = headingZ;
        this.field_70170_p.func_72838_d((Entity)witherMinion);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.launchWitherMinionsToEntity(0, target);
    }

    private double getHeadX(int xPos) {
        if (xPos <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (xPos - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.3;
    }

    private double getHeadY(int yPos) {
        return yPos <= 0 ? this.field_70163_u + 3.0 : this.field_70163_u + 2.2;
    }

    private double getHeadZ(int zPos) {
        if (zPos <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (zPos - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.3;
    }
}

