/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.entity.dungeon.guardianoverlord;

import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.thedragonteam.armorplus.entity.dungeon.base.BossInfoServerDungeon;
import net.thedragonteam.armorplus.entity.dungeon.base.EntityAIRangedDungeonAttack;
import net.thedragonteam.armorplus.entity.dungeon.guardianoverlord.projectile.EntityFreezeBomb;

public class EntityGuardianOverlord
extends EntityWitherSkeleton
implements IRangedAttackMob {
    private final BossInfoServerDungeon bossInfo;
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];

    public EntityGuardianOverlord(World worldIn) {
        super(worldIn);
        this.func_70105_a(this.field_70130_N * 5.0f, this.field_70131_O * 5.0f);
        this.func_110163_bv();
        this.bossInfo = new BossInfoServerDungeon(this.func_145748_c_(), BossInfoServerDungeon.BossInfoDungeonType.GUARDIAN_OVERLORD);
    }

    public static void registerFixesElderGuardian(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityGuardianOverlord.class);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRangedDungeonAttack(this, EntityAIRangedDungeonAttack.EntityAIType.GUARDIAN));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        super.func_184651_r();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(37.5);
    }

    public AxisAlignedBB func_174813_aQ() {
        return super.func_174813_aQ();
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        IntStream.range(1, 3).filter(i -> this.field_70173_aa >= this.nextHeadUpdate[i - 1]).forEachOrdered(i -> {
            this.nextHeadUpdate[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                int j3 = i - 1;
                int k3 = this.idleHeadUpdates[i - 1];
                this.idleHeadUpdates[j3] = this.idleHeadUpdates[i - 1] + 1;
                if (k3 > 15) {
                    double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - 10.0), (double)(this.field_70165_t + 10.0));
                    double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - 5.0), (double)(this.field_70163_u + 5.0));
                    double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - 10.0), (double)(this.field_70161_v + 10.0));
                    this.launchFreezeBombToCoords(i + 1, d0, d1, d2);
                    this.idleHeadUpdates[i - 1] = 0;
                }
            }
        });
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private void launchFreezeBombToEntity(int pos, EntityLivingBase entity) {
        this.launchFreezeBombToCoords(pos, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() * 0.5, entity.field_70161_v);
    }

    private void launchFreezeBombToCoords(int pos, double x, double y, double z) {
        this.field_70170_p.func_180498_a(null, 1024, new BlockPos((Entity)this), 0);
        double headingX = this.getHeadX(pos);
        double headingY = this.getHeadY(pos);
        double headingZ = this.getHeadZ(pos);
        double estimatedX = x - headingX;
        double estimatedY = y - headingY;
        double estimatedZ = z - headingZ;
        EntityFreezeBomb entityFreezeBomb = new EntityFreezeBomb(this.field_70170_p, (EntityLivingBase)this, estimatedX, estimatedY, estimatedZ);
        entityFreezeBomb.field_70163_u = estimatedY;
        entityFreezeBomb.field_70165_t = estimatedX;
        entityFreezeBomb.field_70161_v = estimatedZ;
        this.field_70170_p.func_72838_d((Entity)entityFreezeBomb);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.launchFreezeBombToEntity(0, target);
    }

    private double getHeadX(int xPos) {
        if (xPos <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (xPos - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.3;
    }

    private double getHeadY(int yPos) {
        return yPos <= 0 ? this.field_70163_u + 3.0 : this.field_70163_u + 2.2;
    }

    private double getHeadZ(int zPos) {
        if (zPos <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (zPos - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.3;
    }
}

