/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.enchantments;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.thedragonteam.armorplus.enchantments.EnchantmentBase;

public class LifeStealEnchantment
extends EnchantmentBase {
    public LifeStealEnchantment() {
        super("life_steal", Enchantment.Rarity.RARE, EnumEnchantmentType.BREAKABLE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}, 1, 3, 10, 15, true, true);
    }

    public void func_151368_a(EntityLivingBase user, Entity target, int level) {
        Levels lvl = Levels.values()[level];
        if (user == null) {
            return;
        }
        ItemStack mainHand = user.func_184614_ca();
        Item handItem = mainHand.func_77973_b();
        if (mainHand.func_190926_b()) {
            return;
        }
        if (!this.isCorrectItem(handItem)) {
            user.func_70691_i(lvl.healingFactor);
        } else if (handItem instanceof ItemTool) {
            float damageDealt = ((ItemTool)handItem).field_77862_b.func_78000_c();
            user.func_70691_i((float)level * this.softCap(damageDealt, 10.0f, 1.0f) / 4.0f);
        } else if (handItem instanceof ItemSword) {
            float damageDealt = ((ItemSword)handItem).func_150931_i();
            user.func_70691_i((float)level * this.softCap(damageDealt, 10.0f, 1.0f) / 4.0f);
        }
    }

    private float softCap(float value, float max, float scale) {
        if (value <= max) {
            return value;
        }
        float space = max * scale;
        float offset = value - max;
        return max + space * offset / (space + offset);
    }

    private boolean isCorrectItem(Item item) {
        return item instanceof ItemTool || item instanceof ItemSword;
    }

    public static enum Levels {
        ZERO(0.0f),
        ONE(0.5f),
        TWO(1.5f),
        THREE(2.5f);

        public final float healingFactor;

        private Levels(float healingFactor) {
            this.healingFactor = healingFactor;
        }
    }
}

