/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.enchantments;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.thedragonteam.armorplus.util.Utils;

public abstract class EnchantmentBase
extends Enchantment {
    private int min;
    private int max;
    private int minEnchantability;
    private int maxEnchantability;
    private boolean isTreasure;
    private boolean isBookAllowed;

    public EnchantmentBase(String name, Enchantment.Rarity rarity, EnumEnchantmentType type, EntityEquipmentSlot[] allowedSlots, int min, int max, int minEnchantability, int maxEnchantability, boolean isTreasure, boolean isBookAllowed) {
        super(rarity, type, allowedSlots);
        this.min = min;
        this.max = max;
        this.minEnchantability = minEnchantability;
        this.maxEnchantability = maxEnchantability;
        this.isTreasure = isTreasure;
        this.isBookAllowed = isBookAllowed;
        this.setRegistryName(name);
        this.func_77322_b(Utils.setName(name));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public EnchantmentBase(String name, Enchantment.Rarity rarity, EnumEnchantmentType type, EntityEquipmentSlot[] allowedSlots, int min, int max, boolean isTreasure) {
        this(name, rarity, type, allowedSlots, min, max, 10, 15, isTreasure, false);
    }

    public EnchantmentBase(String name, Enchantment.Rarity rarity, EnumEnchantmentType type, EntityEquipmentSlot[] allowedSlots, int max, boolean isTreasure) {
        this(name, rarity, type, allowedSlots, 1, max, isTreasure);
    }

    public EnchantmentBase(String name, Enchantment.Rarity rarity, EnumEnchantmentType type, EntityEquipmentSlot[] allowedSlots, int min, int max) {
        this(name, rarity, type, allowedSlots, min, max, 10, 15, false, false);
    }

    public int func_77321_a(int enchantmentLevel) {
        return enchantmentLevel * this.minEnchantability;
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + this.maxEnchantability;
    }

    public int func_77325_b() {
        return this.max;
    }

    public int func_77319_d() {
        return this.min;
    }

    public boolean func_185261_e() {
        return this.isTreasure;
    }

    public boolean isAllowedOnBooks() {
        return this.isBookAllowed;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return super.canApplyAtEnchantingTable(stack);
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench);
    }

    public boolean func_92089_a(ItemStack stack) {
        return super.func_92089_a(stack);
    }
}

