/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.container.base;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.thedragonteam.armorplus.container.base.ContainerBase;
import net.thedragonteam.armorplus.container.base.InventoryCraftingImproved;

public class ContainerBenchBase
extends ContainerBase {
    public static int recipeSlots;
    public static int mainInventorySlots;
    public static int fullInventorySlots;
    public World world;

    public ContainerBenchBase(TileEntity tile, int recipeSlotsIn, int mainInventorySlotsIn, int fullInventorySlotsIn) {
        this.world = tile.func_145831_w();
        recipeSlots = recipeSlotsIn;
        mainInventorySlots = mainInventorySlotsIn;
        fullInventorySlots = fullInventorySlotsIn;
    }

    protected static void onContainerClosed(EntityPlayer playerIn, boolean isRemote, int recipeSizeTotal, InventoryCraftingImproved removeItemStack) {
        if (!isRemote) {
            IntStream.range(0, recipeSizeTotal).mapToObj(removeItemStack::func_70304_b).filter(itemstack -> !itemstack.func_190926_b()).forEachOrdered(itemstack -> playerIn.func_71019_a(itemstack, false));
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemstack = slotStack.func_77946_l();
            boolean cannotMergeReverse = this.cannotMergeReverse(slotStack, recipeSlots, fullInventorySlots);
            boolean cannotMergeMainFull = this.cannotMerge(slotStack, mainInventorySlots, fullInventorySlots, false);
            boolean cannotMergeRecipeMain = this.cannotMergeFromRecipeSlots(slotStack, mainInventorySlots);
            boolean cannotMergeRecipeFull = this.cannotMergeFromRecipeSlots(slotStack, fullInventorySlots);
            if (index == 0) {
                slotStack.func_77973_b().func_77622_d(slotStack, this.world, playerIn);
                if (cannotMergeReverse) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotStack, itemstack);
            } else if (this.withinIndex(index, recipeSlots, mainInventorySlots) ? cannotMergeMainFull : (this.withinIndex(index, mainInventorySlots, fullInventorySlots) ? cannotMergeRecipeMain : cannotMergeRecipeFull)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack takenStack = slot.func_190901_a(playerIn, slotStack);
            if (index == 0) {
                playerIn.func_71019_a(takenStack, false);
            }
        }
        return itemstack;
    }

    private boolean withinIndex(int index, int minSlotIndex, int maxSlotIndex) {
        return index >= minSlotIndex && index < maxSlotIndex;
    }

    private boolean cannotMerge(ItemStack slotStack, int slots, int inventorySlots, boolean reverseDirection) {
        return !this.func_75135_a(slotStack, slots, inventorySlots, reverseDirection);
    }

    private boolean cannotMergeReverse(ItemStack slotStack, int slots, int inventorySlots) {
        return this.cannotMerge(slotStack, slots, inventorySlots, true);
    }

    private boolean cannotMergeFromRecipeSlots(ItemStack slotStack, int inventorySlots) {
        return this.cannotMerge(slotStack, recipeSlots, inventorySlots, false);
    }
}

