/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.compat.jei;

import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.recipes.BrokenCraftingRecipeException;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.thedragonteam.armorplus.api.crafting.IRecipe;

public class JEIUtils {
    public static void setRecipe(IRecipeLayout rL, IRecipeWrapper rW, IIngredients in, ICraftingGridHelper cGH, XYProperties prop, int inputSlot, int outputSlot) {
        IGuiItemStackGroup guiItemStacks = rL.getItemStacks();
        guiItemStacks.init(outputSlot, false, prop.xPos, prop.yPos);
        for (int y = 0; y < prop.height; ++y) {
            for (int x = 0; x < prop.width; ++x) {
                int index = inputSlot + x + y * prop.height;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        if (rW instanceof ICustomCraftingRecipeWrapper) {
            ICustomCraftingRecipeWrapper customWrapper = (ICustomCraftingRecipeWrapper)rW;
            customWrapper.setRecipe(rL, in);
            return;
        }
        List inputs = in.getInputs(VanillaTypes.ITEM);
        List outputs = in.getOutputs(VanillaTypes.ITEM);
        if (rW instanceof IShapedCraftingRecipeWrapper) {
            IShapedCraftingRecipeWrapper wrapper = (IShapedCraftingRecipeWrapper)rW;
            cGH.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else {
            cGH.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
            rL.setShapeless();
        }
        if (!outputs.isEmpty()) {
            guiItemStacks.set(outputSlot, (List)outputs.get(0));
        }
    }

    public static void getIngredients(IIngredients ingredients, IRecipe recipe, NonNullList<ItemStack> recipeItems) {
        ItemStack recipeOutput = recipe.getRecipeOutput();
        try {
            ingredients.setInputs(VanillaTypes.ITEM, recipeItems);
            if (!recipeOutput.func_190926_b()) {
                ingredients.setOutput(VanillaTypes.ITEM, (Object)recipeOutput);
            }
        }
        catch (RuntimeException e) {
            String info = ErrorUtil.getInfoFromBrokenCraftingRecipe((Object)recipe, recipeItems, (ItemStack)recipeOutput);
            throw new BrokenCraftingRecipeException(info, (Throwable)e);
        }
    }

    public static void getIngredients(IIngredients ingredients, IRecipe recipe, IJeiHelpers jeiHelpers, List inputItems) {
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        ItemStack recipeOutput = recipe.getRecipeOutput();
        try {
            List inputs = stackHelper.expandRecipeItemStackInputs(inputItems);
            ingredients.setInputLists(VanillaTypes.ITEM, inputs);
            if (!recipeOutput.func_190926_b()) {
                ingredients.setOutput(VanillaTypes.ITEM, (Object)recipeOutput);
            }
        }
        catch (RuntimeException e) {
            String info = ErrorUtil.getInfoFromBrokenCraftingRecipe((Object)recipe, (List)inputItems, (ItemStack)recipeOutput);
            throw new BrokenCraftingRecipeException(info, (Throwable)e);
        }
    }

    public static class XYProperties {
        private final int xPos;
        private final int yPos;
        private final int height;
        private final int width;

        public XYProperties(int xPos, int yPos, int height, int width) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.height = height;
            this.width = width;
        }

        public XYProperties(int xPos, int yPos, int xy) {
            this(xPos, yPos, xy, xy);
        }
    }
}

