/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.compat.jei;

import java.util.Arrays;
import java.util.stream.IntStream;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import net.thedragonteam.armorplus.api.crafting.IRecipe;
import net.thedragonteam.armorplus.api.crafting.base.BaseCraftingManager;
import net.thedragonteam.armorplus.api.crafting.base.BaseShapedOreRecipe;
import net.thedragonteam.armorplus.api.crafting.base.BaseShapedRecipe;
import net.thedragonteam.armorplus.api.crafting.base.BaseShapelessOreRecipe;
import net.thedragonteam.armorplus.api.crafting.base.BaseShapelessRecipe;
import net.thedragonteam.armorplus.client.gui.GuiChampionBench;
import net.thedragonteam.armorplus.client.gui.GuiHighTechBench;
import net.thedragonteam.armorplus.client.gui.GuiLavaInfuser;
import net.thedragonteam.armorplus.client.gui.GuiUltiTechBench;
import net.thedragonteam.armorplus.client.gui.GuiWorkbench;
import net.thedragonteam.armorplus.compat.crafttweaker.lavainfuser.LavaInfuserRecipe;
import net.thedragonteam.armorplus.compat.jei.base.AdvancedRecipeTransferInfo;
import net.thedragonteam.armorplus.compat.jei.base.CategoryBase;
import net.thedragonteam.armorplus.compat.jei.base.CategoryBaseAdvanced;
import net.thedragonteam.armorplus.compat.jei.base.ShapedOreRecipeWrapper;
import net.thedragonteam.armorplus.compat.jei.base.ShapedRecipeWrapper;
import net.thedragonteam.armorplus.compat.jei.base.ShapelessOreRecipeWrapper;
import net.thedragonteam.armorplus.compat.jei.base.ShapelessRecipeWrapper;
import net.thedragonteam.armorplus.compat.jei.lavainfuser.InfuserRecipeMaker;
import net.thedragonteam.armorplus.compat.jei.lavainfuser.LavaInfuserCategory;
import net.thedragonteam.armorplus.compat.jei.lavainfuser.LavaInfuserRecipeWrapper;
import net.thedragonteam.armorplus.compat.jei.misc.OutputSlot;
import net.thedragonteam.armorplus.compat.jei.misc.UVData;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.container.ContainerChampionBench;
import net.thedragonteam.armorplus.container.ContainerHighTechBench;
import net.thedragonteam.armorplus.container.ContainerLavaInfuser;
import net.thedragonteam.armorplus.container.ContainerUltiTechBench;
import net.thedragonteam.armorplus.container.ContainerWorkbench;
import net.thedragonteam.armorplus.registry.APItems;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.util.TextUtils;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

@Optional.Interface(iface="mezz.jei.api.ingredients.IIngredientBlacklist", modid="jei", striprefs=true)
@JEIPlugin
public class ArmorPlusPlugin
implements IModPlugin {
    public static final String JEI_CATEGORY_WORKBENCH = Utils.setLocation("workbench");
    public static final String JEI_CATEGORY_HIGH_TECH_BENCH = Utils.setLocation("high_tech_bench");
    public static final String JEI_CATEGORY_ULTI_TECH_BENCH = Utils.setLocation("ulti_tech_bench");
    public static final String JEI_CATEGORY_CHAMPION_BENCH = Utils.setLocation("champion_bench");
    public static final String JEI_CATEGORY_LAVA_INFUSER = Utils.setLocation("lava_infuser_infusing");
    public static final String[] JEI_CATEGORIES = new String[]{JEI_CATEGORY_WORKBENCH, JEI_CATEGORY_HIGH_TECH_BENCH, JEI_CATEGORY_ULTI_TECH_BENCH, JEI_CATEGORY_CHAMPION_BENCH};
    public static IJeiHelpers jeiHelper;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelper = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new CategoryBase("workbench", new UVData(29, 16, 116, 54), new OutputSlot(94, 18), 3, JEI_CATEGORY_WORKBENCH), new CategoryBase("high_tech_bench", new UVData(11, 16, 156, 93), new OutputSlot(136, 36), 5, JEI_CATEGORY_HIGH_TECH_BENCH), new CategoryBaseAdvanced("ulti_tech_bench", new UVData(11, 16, 178, 126), new OutputSlot(156, 54), 7, JEI_CATEGORY_ULTI_TECH_BENCH, 160, 80), new CategoryBaseAdvanced("champion_bench", new UVData(11, 16, 162, 162), new OutputSlot(72, 168), 9, JEI_CATEGORY_CHAMPION_BENCH, 100, 170), new LavaInfuserCategory()});
    }

    public void register(IModRegistry registry) {
        if (ModConfig.IntegrationsConfig.enableJEIIntegration) {
            jeiHelper = registry.getJeiHelpers();
            IIngredientBlacklist blacklist = jeiHelper.getIngredientBlacklist();
            this.registerDescriptions(registry);
            this.blackListIngredients(blacklist, ModItems.moddedCityItem, ModItems.jonBamsItem, ItemStackUtils.getItemStack((Object)ModItems.jonBamsItem, (int)1), ModItems.theDragonTeamItem, ModItems.twitchItem, ModItems.beamItem, ModItems.btmMoon, ModItems.m1Jordan, ModItems.teamRapture);
            Arrays.stream(ModItems.horseArmors).forEach(horseArmor -> this.blackListIngredients(blacklist, horseArmor));
            Arrays.stream(ModBlocks.enderBlocks).forEach(enderBlocks -> this.blackListIngredients(blacklist, enderBlocks));
        }
        jeiHelper = registry.getJeiHelpers();
        registry.handleRecipes(LavaInfuserRecipe.class, LavaInfuserRecipeWrapper::new, JEI_CATEGORY_LAVA_INFUSER);
        this.handleRecipes(registry, JEI_CATEGORY_WORKBENCH);
        this.handleRecipes(registry, JEI_CATEGORY_HIGH_TECH_BENCH);
        this.handleRecipes(registry, JEI_CATEGORY_ULTI_TECH_BENCH);
        this.handleRecipes(registry, JEI_CATEGORY_CHAMPION_BENCH);
        registry.addRecipeClickArea(GuiWorkbench.class, 88, 32, 28, 23, new String[]{JEI_CATEGORY_WORKBENCH});
        registry.addRecipeClickArea(GuiHighTechBench.class, 112, 50, 28, 27, new String[]{JEI_CATEGORY_HIGH_TECH_BENCH});
        registry.addRecipeClickArea(GuiUltiTechBench.class, 138, 70, 24, 17, new String[]{JEI_CATEGORY_ULTI_TECH_BENCH});
        registry.addRecipeClickArea(GuiChampionBench.class, 185, 23, 24, 17, new String[]{JEI_CATEGORY_CHAMPION_BENCH});
        registry.addRecipeClickArea(GuiLavaInfuser.class, 92, 34, 28, 27, new String[]{JEI_CATEGORY_LAVA_INFUSER});
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerWorkbench.class, JEI_CATEGORY_WORKBENCH, 1, 9, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerHighTechBench.class, JEI_CATEGORY_HIGH_TECH_BENCH, 1, 25, 26, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerUltiTechBench.class, JEI_CATEGORY_ULTI_TECH_BENCH, 1, 49, 50, 36);
        recipeTransferRegistry.addRecipeTransferHandler(new AdvancedRecipeTransferInfo<ContainerChampionBench>(ContainerChampionBench.class, JEI_CATEGORY_CHAMPION_BENCH, 1, 81, 82, 36));
        recipeTransferRegistry.addRecipeTransferHandler(ContainerLavaInfuser.class, JEI_CATEGORY_LAVA_INFUSER, 0, 1, 3, 36);
        registry.addRecipeCatalyst((Object)ItemStackUtils.getItemStack((Object)ModBlocks.lavaInfuser), new String[]{JEI_CATEGORY_LAVA_INFUSER});
        IntStream.range(0, JEI_CATEGORIES.length).forEach(i -> registry.addRecipeCatalyst((Object)ItemStackUtils.getItemStack((Object)ModBlocks.benches[i]), new String[]{JEI_CATEGORIES[i]}));
        registry.addRecipes(BaseCraftingManager.getWBInstance().getRecipeList(), JEI_CATEGORY_WORKBENCH);
        registry.addRecipes(BaseCraftingManager.getHTBInstance().getRecipeList(), JEI_CATEGORY_HIGH_TECH_BENCH);
        registry.addRecipes(BaseCraftingManager.getUTBInstance().getRecipeList(), JEI_CATEGORY_ULTI_TECH_BENCH);
        registry.addRecipes(BaseCraftingManager.getCBInstance().getRecipeList(), JEI_CATEGORY_CHAMPION_BENCH);
        registry.addRecipes(InfuserRecipeMaker.getInfuserRecipes(), JEI_CATEGORY_LAVA_INFUSER);
    }

    private void handleRecipes(IModRegistry registry, String category) {
        registry.handleRecipes(BaseShapedRecipe.class, recipe -> new ShapedRecipeWrapper((IRecipe)recipe, recipe.input, recipe.getRecipeWidth(), recipe.getRecipeHeight()), category);
        registry.handleRecipes(BaseShapelessRecipe.class, recipe -> new ShapelessRecipeWrapper((IRecipe)recipe, recipe.input), category);
        registry.handleRecipes(BaseShapelessOreRecipe.class, recipe -> new ShapelessOreRecipeWrapper(jeiHelper, (IRecipe)recipe, recipe.getInput()), category);
        registry.handleRecipes(BaseShapedOreRecipe.class, recipe -> new ShapedOreRecipeWrapper(jeiHelper, (IRecipe)recipe, recipe.getInput(), recipe.getRecipeWidth(), recipe.getRecipeHeight()), category);
    }

    private void blackListIngredients(IIngredientBlacklist blacklist, Object ... stacks) {
        Arrays.stream(stacks).forEachOrdered(stack -> {
            if (stack instanceof ItemStack || stack instanceof Block || stack instanceof Item) {
                blacklist.addIngredientToBlacklist((Object)ItemStackUtils.getItemStack((Object)stack));
            }
        });
    }

    private void registerDescriptions(IModRegistry registry) {
        this.registerDescriptions(registry, this.createDesc(APItems.guardianScale, "armorplus.jei.guardian_scale.desc"), this.createDesc(APItems.witherBone, "armorplus.jei.wither_bone.desc"), this.createDesc(APItems.enderDragonScale, "armorplus.jei.ender_dragon_scale.desc"), this.createDesc(ItemStackUtils.getItemStack((Object)ModBlocks.lavaInfuser), "armorplus.jei.lava_infuser.desc"));
    }

    private void registerDescriptions(IModRegistry registry, EntryDescription entry) {
        registry.addIngredientInfo((Object)entry.getStack(), VanillaTypes.ITEM, new String[]{TextUtils.formattedText(entry.getDesc(), new Object[0])});
    }

    private void registerDescriptions(IModRegistry registry, EntryDescription ... entries) {
        Arrays.stream(entries).forEachOrdered(entry -> this.registerDescriptions(registry, (EntryDescription)entry));
    }

    private EntryDescription createDesc(ItemStack stack, String desc) {
        return new EntryDescription(stack, desc);
    }

    private class EntryDescription {
        private final ItemStack stack;
        private final String desc;

        public EntryDescription(ItemStack stack, String desc) {
            this.stack = stack;
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

