/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.compat.crafttweaker.lavainfuser;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import net.thedragonteam.armorplus.api.lavainfuser.LavaInfuserManager;
import net.thedragonteam.armorplus.compat.crafttweaker.InputHelper;
import net.thedragonteam.armorplus.compat.crafttweaker.lavainfuser.LavaInfuserRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.armorplus.LavaInfuser")
public class LavaInfuser {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, double xp) {
        CraftTweakerAPI.apply((IAction)new Add(new LavaInfuserRecipe(InputHelper.toStack(input), InputHelper.toStack(output), xp)));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        CraftTweakerAPI.apply((IAction)new Remove(InputHelper.toStack(target)));
    }

    private static class Add
    implements IAction {
        private LavaInfuserRecipe recipe;

        public Add(LavaInfuserRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            LavaInfuserManager.getInstance().addInfusingRecipe(this.recipe);
        }

        public String describe() {
            return "Adding Lava Infuser recipe for " + this.recipe.getRecipeOutput().func_82833_r();
        }
    }

    private static class Remove
    implements IAction {
        ItemStack remove;

        public Remove(ItemStack rem) {
            this.remove = rem;
        }

        public void apply() {
            for (LavaInfuserRecipe obj : LavaInfuserManager.getInstance().getRecipeList()) {
                LavaInfuserRecipe craft;
                if (!(obj instanceof LavaInfuserRecipe) || !(craft = obj).getRecipeOutput().func_77969_a(this.remove)) continue;
                LavaInfuserManager.getInstance().getRecipeList().remove(obj);
                break;
            }
        }

        public String describe() {
            return "Removing Lava Infuser recipe for " + this.remove.func_82833_r();
        }
    }
}

