/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.client.utils;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.api.properties.AbilityProvider;
import net.thedragonteam.armorplus.api.properties.iface.IEffectHolder;
import net.thedragonteam.armorplus.items.weapons.effects.Ignite;
import net.thedragonteam.armorplus.items.weapons.effects.Negative;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.RomanNumeralUtil;
import net.thedragonteam.armorplus.util.Utils;

@SideOnly(value=Side.CLIENT)
public final class ToolTipUtils {
    public static void showInfo(List<String> tooltip, KeyBinding keyBinding, TextFormatting formatting) {
        tooltip.add(MessageFormat.format("{0}{1} {2}{3} {4}{5}", TextFormatting.GRAY, new TextComponentTranslation("tooltip.shift.showinfo.text_one", new Object[0]).func_150254_d(), formatting, keyBinding.getDisplayName(), TextFormatting.GRAY, new TextComponentTranslation("tooltip.shift.showinfo.text_two", new Object[0]).func_150254_d()));
    }

    public static void addToolTipFull(List<String> tooltip, List<String> abilities, List<Integer> amplifier) {
        int colorIndex = 1;
        ToolTipUtils.abilitySorter(tooltip, abilities, amplifier, colorIndex, true);
    }

    public static void addToolTipFull(List<String> tooltip, IEffectHolder effectHolder) {
        int colorIndex = 1;
        AbilityProvider applicable = effectHolder.getApplicableAbilities();
        ToolTipUtils.abilitySorter(tooltip, Utils.boxList(applicable.getAbilities().name), Utils.boxList(applicable.getAbilities().level), colorIndex, true);
    }

    public static void addToolTipPiece(List<String> tooltip, List<String> abilities, List<Integer> amplifier) {
        int colorIndex = 1;
        ToolTipUtils.abilitySorter(tooltip, abilities, amplifier, colorIndex, false);
    }

    public static void addToolTipPiece(List<String> tooltip, IEffectHolder effectHolder) {
        ToolTipUtils.addToolTipPiece(tooltip, effectHolder, false);
    }

    public static void addToolTipPiece(List<String> tooltip, IEffectHolder effectHolder, boolean areFullSet) {
        int colorIndex = 1;
        AbilityProvider applicable = effectHolder.getApplicableAbilities();
        ToolTipUtils.abilitySorter(tooltip, Utils.boxList(applicable.getAbilities().name), Utils.boxList(applicable.getAbilities().level), colorIndex, false);
    }

    private static void abilitySorter(List<String> tooltip, List<String> abilities, List<Integer> amplifier, int colorIndex, boolean areFullSet) {
        ToolTipUtils.addToolTip(tooltip, areFullSet ? "\u00a79Full set abilities" : "\u00a79Abilities");
        for (int abilityIndex = 0; abilityIndex < abilities.size(); ++abilityIndex) {
            if (abilities.get(abilityIndex).contains("empty")) continue;
            List localizedEffects = abilities.stream().map(PotionUtils::localizePotion).collect(Collectors.toList());
            TextFormatting abilityFormatting = TextFormatting.func_175744_a((int)(++colorIndex % 15));
            ToolTipUtils.addToolTip(tooltip, String.format("%s%s %s", String.valueOf(abilityFormatting), localizedEffects.get(abilityIndex), RomanNumeralUtil.generate(ToolTipUtils.level(amplifier.get(abilityIndex)))));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addSpecialInformation(List<String> tooltip, Negative negative, Ignite ignite, TextFormatting formatting) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (!GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, formatting);
        } else {
            tooltip.add("\u00a79Abilities");
            if (!ignite.isEnabled() && !negative.isEnabled()) {
                tooltip.add("\u00a79none");
            }
            if (ignite.isEnabled()) {
                tooltip.add("\u00a76Sets the entities on fire for " + ignite.getFireSeconds() + " seconds");
            }
            if (negative.isEnabled()) {
                String[] negativeEffects = negative.getEffects();
                int[] effectLevels = negative.getEffectLevels();
                int colorIndex = 1;
                for (int abilityIndex = 0; abilityIndex < negativeEffects.length; ++abilityIndex) {
                    if (negativeEffects[abilityIndex].contains("empty")) continue;
                    TextFormatting abilityFormatting = TextFormatting.func_175744_a((int)(++colorIndex % 15));
                    tooltip.add(String.format("%s%s %s", abilityFormatting, PotionUtils.localizePotion(negativeEffects[abilityIndex]), RomanNumeralUtil.generate(effectLevels[abilityIndex] + 1)));
                }
            }
        }
    }

    public static boolean isKeyDown() {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        return GameSettings.func_100015_a((KeyBinding)keyBindSneak);
    }

    private static int level(int amplifier) {
        return amplifier + 1;
    }

    public static void addToolTip(List<String> tooltip, String ... lines) {
        tooltip.addAll(Arrays.asList(lines));
    }
}

