/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.blocks.special;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.blocks.BlockProperties;
import net.thedragonteam.armorplus.blocks.base.BlockBase;
import net.thedragonteam.armorplus.blocks.base.ToolType;
import net.thedragonteam.armorplus.blocks.special.Trophy;
import net.thedragonteam.armorplus.iface.IModdedBlock;
import net.thedragonteam.armorplus.tileentity.TileTrophy;

public class BlockTrophy
extends BlockBase
implements IModdedBlock {
    private Trophy type;

    public BlockTrophy(Trophy type) {
        super(Material.field_151589_v, type == Trophy.ANY ? "trophy" : type.getName() + "_trophy", new BlockProperties(20.0f, 3.0f, ToolType.PICKAXE, 1));
        this.type = type;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileTrophy trophy = new TileTrophy();
        trophy.setEntityId(this.type.getEntityId());
        trophy.setEntityScale(this.type.getScale());
        return trophy;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (stack.func_82837_s() && tileentity instanceof TileTrophy) {
            ((TileTrophy)tileentity).setCustomName(stack.func_82833_r());
        }
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemstack = super.getPickBlock(state, target, world, pos, player);
        TileTrophy tileTrophy = (TileTrophy)world.func_175625_s(pos);
        NBTTagCompound nbttagcompound = tileTrophy.saveToNbt(new NBTTagCompound());
        if (!nbttagcompound.func_82582_d()) {
            itemstack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        }
        return itemstack;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        this.initModel(0, "normal");
    }
}

