/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.armors.base;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.api.properties.AbilityCanceller;
import net.thedragonteam.armorplus.api.properties.AbilityProvider;
import net.thedragonteam.armorplus.api.properties.iface.IEffectHolder;
import net.thedragonteam.armorplus.client.utils.ToolTipUtils;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.iface.IModdedItem;
import net.thedragonteam.armorplus.registry.APItems;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.util.ArmorPlusItemUtils;
import net.thedragonteam.armorplus.util.EnumHelperUtil;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public class ItemUltimateArmor
extends ItemArmor
implements IModdedItem,
IEffectHolder {
    public static final ItemArmor.ArmorMaterial theUltimateArmor = EnumHelperUtil.addArmorMaterial("THE_ULTIMATE_ARMOR", "the_ultimate_armor", 160, ModConfig.RegistryConfig.ultimate.armor.protectionPoints, 1, SoundEvents.field_187716_o, ModConfig.RegistryConfig.ultimate.armor.toughnessPoints);
    private ModConfig.RegistryConfig.UltimateMaterial.Armor armor;

    public ItemUltimateArmor(EntityEquipmentSlot slot) {
        super(theUltimateArmor, 0, slot);
        this.armor = ModConfig.RegistryConfig.ultimate.armor;
        this.func_77625_d(1);
        this.createPieces(slot);
        this.func_77637_a(ArmorPlus.tabArmorplus);
    }

    private void createPieces(EntityEquipmentSlot slot) {
        String piece = slot == EntityEquipmentSlot.HEAD ? "the_ultimate_helmet" : (slot == EntityEquipmentSlot.CHEST ? "the_ultimate_chestplate" : (slot == EntityEquipmentSlot.LEGS ? "the_ultimate_leggings" : (slot == EntityEquipmentSlot.FEET ? "the_ultimate_boots" : "")));
        this.setRegistryName(Utils.setRL(piece));
        this.func_77655_b(Utils.setName(piece));
    }

    public void onArmorTick(EntityPlayer player) {
        boolean isAllowed;
        PlayerCapabilities caps = player.field_71075_bZ;
        boolean isFullSet = ArmorPlusItemUtils.isFullSet(player, APItems.theUltimateHelmet, APItems.theUltimateChestplate, APItems.theUltimateLeggings, APItems.theUltimateBoots);
        boolean bl = isAllowed = isFullSet || caps.field_75098_d || player.func_175149_v();
        if (ModConfig.Misc.enableFlightAbility) {
            if (isAllowed) {
                caps.field_75101_c = true;
            } else {
                caps.field_75100_b = false;
                caps.field_75101_c = false;
            }
        }
        if (this.armor.setInvincible) {
            caps.field_75102_a = isAllowed;
            PotionUtils.addPotion((EntityLivingBase)player, MobEffects.field_76443_y, 120, 0, PotionUtils.PotionType.GOOD);
        }
        if (isFullSet) {
            ArmorPlusItemUtils.applyEffects(player, this);
        } else if (this.armor.enableDeBuffs) {
            PotionUtils.addPotion((EntityLivingBase)player, MobEffects.field_76436_u, 60, 2, PotionUtils.PotionType.BAD);
            PotionUtils.addPotion((EntityLivingBase)player, MobEffects.field_76421_d, 60, 2, PotionUtils.PotionType.BAD);
            PotionUtils.addPotion((EntityLivingBase)player, MobEffects.field_76440_q, 60, 0, PotionUtils.PotionType.BAD);
            player.field_70159_w = 0.0;
            if (player.field_70122_E) {
                player.field_70181_x = 0.0;
            }
            player.field_70179_y = 0.0;
            player.field_70133_I = true;
        }
    }

    @Override
    public AbilityProvider getApplicableAbilities() {
        return new AbilityProvider(this.armor.addPotionEffects, this.armor.effectLevels, this.armor.effectDurations);
    }

    @Override
    public AbilityCanceller getRemovableAbilities() {
        return new AbilityCanceller(this.armor.removePotionEffects);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.getRarity("ULTIMATE_ARMOR_COLOR", ModConfig.RegistryConfig.ultimate.armor.itemNameColor, "Ultimate Armor Color");
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add("\u00a79Question: \u00a7rAre you the chosen one ?");
            tooltip.add("\u00a7cRequires the full set equipped");
        } else {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, TextFormatting.func_96300_b((String)ModConfig.RegistryConfig.ultimate.armor.itemNameColor));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        boolean isUnbreakable = false;
        if (tagCompound != null) {
            isUnbreakable = tagCompound.func_74767_n("Unbreakable");
        }
        if (ModConfig.RegistryConfig.ultimate.armor.setUnbreakable && !isUnbreakable) {
            Utils.setUnbreakable(stack);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.onArmorTick(player);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ArmorPlusItemUtils.isItemRepairable(repair, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)4));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        this.initModel("ultimate");
    }
}

