/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.armors.base;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.armors.APArmorMaterial;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.iface.IModdedItem;
import net.thedragonteam.armorplus.util.ArmorPlusItemUtils;
import net.thedragonteam.armorplus.util.EnumHelperUtil;
import net.thedragonteam.armorplus.util.EnumTiers;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class ItemArmorBase
extends ItemArmor
implements IModdedItem {
    public static final ItemArmor.ArmorMaterial coalArmor = EnumHelperUtil.addArmorMaterial("COAL", "coal_armor", 2, ModConfig.RegistryConfig.coal.armor.protectionPoints, ModConfig.RegistryConfig.coal.armor.toughnessPoints, EnumTiers.TIER_1);
    public static final ItemArmor.ArmorMaterial lapisArmor = EnumHelperUtil.addArmorMaterial("LAPIS", "lapis_armor", 11, ModConfig.RegistryConfig.lapis.armor.protectionPoints, ModConfig.RegistryConfig.lapis.armor.toughnessPoints, EnumTiers.TIER_1);
    public static final ItemArmor.ArmorMaterial redstoneArmor = EnumHelperUtil.addArmorMaterial("REDSTONE", "redstone_armor", 11, ModConfig.RegistryConfig.redstone.armor.protectionPoints, ModConfig.RegistryConfig.redstone.armor.toughnessPoints, EnumTiers.TIER_1);
    public static final ItemArmor.ArmorMaterial emeraldArmor = EnumHelperUtil.addArmorMaterial("EMERALD", "emerald_armor", 35, ModConfig.RegistryConfig.emerald.armor.protectionPoints, ModConfig.RegistryConfig.emerald.armor.toughnessPoints, EnumTiers.TIER_2);
    public static final ItemArmor.ArmorMaterial obsidianArmor = EnumHelperUtil.addArmorMaterial("OBSIDIAN", "obsidian_armor", 40, ModConfig.RegistryConfig.obsidian.armor.protectionPoints, ModConfig.RegistryConfig.obsidian.armor.toughnessPoints, EnumTiers.TIER_2);
    public static final ItemArmor.ArmorMaterial lavaArmor = EnumHelperUtil.addArmorMaterial("INFUSED_LAVA", "lava_armor", 45, ModConfig.RegistryConfig.lava.armor.protectionPoints, ModConfig.RegistryConfig.lava.armor.toughnessPoints, EnumTiers.TIER_2);
    public static final ItemArmor.ArmorMaterial guardianArmor = EnumHelperUtil.addArmorMaterial("GUARDIAN", "guardian_armor", 50, ModConfig.RegistryConfig.guardian.armor.protectionPoints, ModConfig.RegistryConfig.guardian.armor.toughnessPoints, EnumTiers.TIER_3);
    public static final ItemArmor.ArmorMaterial superStarArmor = EnumHelperUtil.addArmorMaterial("SUPER_STAR", "super_star_armor", 50, ModConfig.RegistryConfig.super_star.armor.protectionPoints, ModConfig.RegistryConfig.super_star.armor.toughnessPoints, EnumTiers.TIER_3);
    public static final ItemArmor.ArmorMaterial enderDragonArmor = EnumHelperUtil.addArmorMaterial("ENDER_DRAGON", "ender_dragon_armor", 60, ModConfig.RegistryConfig.ender_dragon.armor.protectionPoints, ModConfig.RegistryConfig.ender_dragon.armor.toughnessPoints, EnumTiers.TIER_3);
    public static final ItemArmor.ArmorMaterial chickenArmor = EnumHelperUtil.addArmorMaterial("CHICKEN", "chicken_armor", 1, ModConfig.RegistryConfig.chicken.protectionPoints, ModConfig.RegistryConfig.chicken.toughnessPoints, EnumTiers.TIER_1);
    public static final ItemArmor.ArmorMaterial slimeArmor = EnumHelperUtil.addArmorMaterial("SLIME", "slime_armor", 1, ModConfig.RegistryConfig.slime.protectionPoints, ModConfig.RegistryConfig.slime.toughnessPoints, EnumTiers.TIER_1);
    public static final ItemArmor.ArmorMaterial arditeArmor = EnumHelperUtil.addArmorMaterial("ARDITE", "ardite_armor", 55, ModConfig.RegistryConfig.ardite.protectionPoints, ModConfig.RegistryConfig.ardite.toughnessPoints, EnumTiers.TIER_2);
    public static final ItemArmor.ArmorMaterial cobaltArmor = EnumHelperUtil.addArmorMaterial("COBALT", "cobalt_armor", 44, ModConfig.RegistryConfig.cobalt.protectionPoints, ModConfig.RegistryConfig.cobalt.toughnessPoints, EnumTiers.TIER_2);
    public static final ItemArmor.ArmorMaterial knightSlimeArmor = EnumHelperUtil.addArmorMaterial("KNIGHT_SLIME", "knight_slime_armor", 33, ModConfig.RegistryConfig.knight_slime.protectionPoints, ModConfig.RegistryConfig.knight_slime.toughnessPoints, EnumTiers.TIER_2);
    public static final ItemArmor.ArmorMaterial manyullynArmor = EnumHelperUtil.addArmorMaterial("MANYULLYN", "manyullyn_armor", 66, ModConfig.RegistryConfig.manyullyn.protectionPoints, ModConfig.RegistryConfig.manyullyn.toughnessPoints, EnumTiers.TIER_2);
    public static final ItemArmor.ArmorMaterial pigIronArmor = EnumHelperUtil.addArmorMaterial("PIG_IRON", "pig_iron_armor", 33, ModConfig.RegistryConfig.pig_iron.protectionPoints, ModConfig.RegistryConfig.pig_iron.toughnessPoints, EnumTiers.TIER_2);
    public EntityEquipmentSlot slot;
    private EnumAction wear = EnumHelperUtil.addAction("WEAR");
    public APArmorMaterial field_77878_bZ;
    private ItemStack repairStack;

    public ItemArmorBase(APArmorMaterial material, EntityEquipmentSlot slot) {
        super(material.getArmorMaterial(), 0, slot);
        this.setMaterial(material);
        this.setRepairStack(material.getRepairStack());
        this.setSlot(slot);
        this.func_77625_d(1);
        this.createPieces(slot, material.getName());
        this.func_77637_a(ArmorPlus.tabArmorplus);
    }

    private void createPieces(EntityEquipmentSlot slot, String name) {
        String piece = name + (slot == EntityEquipmentSlot.HEAD ? "_helmet" : (slot == EntityEquipmentSlot.CHEST ? "_chestplate" : (slot == EntityEquipmentSlot.LEGS ? "_leggings" : (slot == EntityEquipmentSlot.FEET ? "_boots" : ""))));
        this.setRegistryName(Utils.setRL(piece));
        this.func_77655_b(Utils.setName(piece));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        boolean isUnbreakable = false;
        if (tagCompound != null) {
            isUnbreakable = tagCompound.func_74767_n("Unbreakable");
        }
        if (this.field_77878_bZ.isUnbreakable() && !isUnbreakable) {
            Utils.setUnbreakable(stack);
            LogHelper.info((Object)"Making The Ultimate Armor Unbreakable!");
        }
    }

    public void setMaterial(APArmorMaterial material) {
        this.field_77878_bZ = material;
    }

    public void setSlot(EntityEquipmentSlot slot) {
        this.slot = slot;
    }

    public void setRepairStack(ItemStack repairStack) {
        this.repairStack = repairStack;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.getRarity("ARMOR_COLOR", this.field_77878_bZ.getFormatting(), "Armor Color");
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.field_77878_bZ.isEnabled()) {
            this.field_77878_bZ.onArmorTick(player, this.slot);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ArmorPlusItemUtils.isItemRepairable(repair, this.repairStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        this.field_77878_bZ.addInformation(stack, world, tooltip, advanced);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.wear;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        this.initModel(this.field_77878_bZ.getName());
    }
}

