/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.armors;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.api.properties.AbilityCanceller;
import net.thedragonteam.armorplus.api.properties.AbilityProvider;
import net.thedragonteam.armorplus.api.properties.iface.IEffectHolder;
import net.thedragonteam.armorplus.api.properties.iface.IRemovable;
import net.thedragonteam.armorplus.api.properties.iface.IRepairable;
import net.thedragonteam.armorplus.armors.base.ItemArmorBase;
import net.thedragonteam.armorplus.client.utils.ToolTipUtils;
import net.thedragonteam.armorplus.config.Abilities;
import net.thedragonteam.armorplus.config.ModConfig;
import net.thedragonteam.armorplus.registry.APItems;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.util.ArmorPlusItemUtils;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public enum APArmorMaterial implements IEffectHolder,
IRepairable,
IRemovable
{
    COAL(ItemArmorBase.coalArmor, ModConfig.RegistryConfig.global_registry.enableCoalArmor, ModConfig.RegistryConfig.coal.armor){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.coalHelmet, APItems.coalChestplate, APItems.coalLeggings, APItems.coalBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)Blocks.field_150402_ci);
        }
    }
    ,
    LAPIS(ItemArmorBase.lapisArmor, ModConfig.RegistryConfig.global_registry.enableLapisArmor, ModConfig.RegistryConfig.lapis.armor){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.lapisHelmet, APItems.lapisChestplate, APItems.lapisLeggings, APItems.lapisBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)Blocks.field_150368_y);
        }
    }
    ,
    REDSTONE(ItemArmorBase.redstoneArmor, ModConfig.RegistryConfig.global_registry.enableRedstoneArmor, ModConfig.RegistryConfig.redstone.armor){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.redstoneHelmet, APItems.redstoneChestplate, APItems.redstoneLeggings, APItems.redstoneBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)Blocks.field_150451_bX);
        }
    }
    ,
    EMERALD(ItemArmorBase.emeraldArmor, ModConfig.RegistryConfig.global_registry.enableEmeraldArmor, ModConfig.RegistryConfig.emerald.armor){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.emeraldHelmet, APItems.emeraldChestplate, APItems.emeraldLeggings, APItems.emeraldBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)Blocks.field_150475_bE);
        }
    }
    ,
    OBSIDIAN(ItemArmorBase.obsidianArmor, ModConfig.RegistryConfig.global_registry.enableObsidianArmor, ModConfig.RegistryConfig.obsidian.armor){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.obsidianHelmet, APItems.obsidianChestplate, APItems.obsidianLeggings, APItems.obsidianBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedObsidian);
        }
    }
    ,
    INFUSED_LAVA(ItemArmorBase.lavaArmor, ModConfig.RegistryConfig.global_registry.enableLavaArmor, ModConfig.RegistryConfig.lava.armor){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            if (!ModConfig.RegistryConfig.lava.armor.enableSetEffects) {
                player.func_70066_B();
                player.func_110149_m(player.func_180799_ab() ? 4.0f : 0.0f);
                if (ModConfig.RegistryConfig.lava.armor.enableOnWaterTouchDeBuff && player.func_70090_H() && player.func_70660_b(MobEffects.field_76427_o) == null) {
                    PotionUtils.addPotion((EntityLivingBase)player, MobEffects.field_76421_d, 1, PotionUtils.PotionType.BAD);
                    for (ItemStack e : player.func_184193_aE()) {
                        e.func_77972_a(1, (EntityLivingBase)player);
                    }
                    player.func_70097_a(DamageSource.field_76369_e, 1.0f);
                }
            } else if (ArmorPlusItemUtils.isFullSet(player, APItems.lavaHelmet, APItems.lavaChestplate, APItems.lavaLeggings, APItems.lavaBoots)) {
                player.func_70066_B();
                if (player.func_180799_ab()) {
                    player.func_110149_m(4.0f);
                }
                if (player.func_70090_H() && ModConfig.RegistryConfig.lava.armor.enableOnWaterTouchDeBuff && player.func_70660_b(MobEffects.field_76427_o) == null) {
                    PotionUtils.addPotion((EntityLivingBase)player, MobEffects.field_76421_d, 120, 1, PotionUtils.PotionType.BAD);
                    for (ItemStack e : player.func_184193_aE()) {
                        e.func_77972_a(1, (EntityLivingBase)player);
                    }
                    player.func_70097_a(DamageSource.field_76369_e, 1.0f);
                }
            }
            this.addEffects(player, slot, APItems.lavaHelmet, APItems.lavaChestplate, APItems.lavaLeggings, APItems.lavaBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1);
        }
    }
    ,
    GUARDIAN(ItemArmorBase.guardianArmor, ModConfig.RegistryConfig.global_registry.enableGuardianArmor, ModConfig.RegistryConfig.guardian.armor){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.guardianHelmet, APItems.guardianChestplate, APItems.guardianLeggings, APItems.guardianBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)ModItems.materials, (int)1);
        }
    }
    ,
    SUPER_STAR(ItemArmorBase.superStarArmor, ModConfig.RegistryConfig.global_registry.enableSuperStarArmor, ModConfig.RegistryConfig.super_star.armor){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.superStarHelmet, APItems.superStarChestplate, APItems.superStarLeggings, APItems.superStarBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)ModItems.materials, (int)2);
        }
    }
    ,
    ENDER_DRAGON(ItemArmorBase.enderDragonArmor, ModConfig.RegistryConfig.global_registry.enableEnderDragonArmor, ModConfig.RegistryConfig.ender_dragon.armor){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            if (ModConfig.Misc.enableFlightAbility) {
                if (ArmorPlusItemUtils.isFullSet(player, APItems.enderDragonHelmet, APItems.enderDragonChestplate, APItems.enderDragonLeggings, APItems.enderDragonBoots)) {
                    player.field_71075_bZ.field_75101_c = true;
                } else {
                    player.field_71075_bZ.field_75100_b = false;
                    player.field_71075_bZ.field_75101_c = false;
                }
            }
            this.addEffects(player, slot, APItems.enderDragonHelmet, APItems.enderDragonChestplate, APItems.enderDragonLeggings, APItems.enderDragonBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)ModItems.materials, (int)3);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
            super.addInformation(stack, world, tooltip, advanced);
            if (ToolTipUtils.isKeyDown()) {
                ToolTipUtils.addToolTip(tooltip, "\u00c2\u00a7eSpecial ability: Flight");
            }
        }
    }
    ,
    ARDITE(ItemArmorBase.arditeArmor, ModConfig.RegistryConfig.global_registry.enableArditeArmor, ModConfig.RegistryConfig.ardite){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.arditeHelmet, APItems.arditeChestplate, APItems.arditeLeggings, APItems.arditeBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return Utils.getTCIngot(1);
        }
    }
    ,
    COBALT(ItemArmorBase.cobaltArmor, ModConfig.RegistryConfig.global_registry.enableCobaltArmor, ModConfig.RegistryConfig.cobalt){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.cobaltHelmet, APItems.cobaltChestplate, APItems.cobaltLeggings, APItems.cobaltBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return Utils.getTCIngot(0);
        }
    }
    ,
    MANYULLYN(ItemArmorBase.manyullynArmor, ModConfig.RegistryConfig.global_registry.enableManyullynArmor, ModConfig.RegistryConfig.manyullyn){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.manyullynHelmet, APItems.manyullynChestplate, APItems.manyullynLeggings, APItems.manyullynBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return Utils.getTCIngot(2);
        }
    }
    ,
    KNIGHT_SLIME(ItemArmorBase.knightSlimeArmor, ModConfig.RegistryConfig.global_registry.enableKnightSlimeArmor, ModConfig.RegistryConfig.knight_slime){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.knightSlimeHelmet, APItems.knightSlimeChestplate, APItems.knightSlimeLeggings, APItems.knightSlimeBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return Utils.getTCIngot(3);
        }
    }
    ,
    PIG_IRON(ItemArmorBase.pigIronArmor, ModConfig.RegistryConfig.global_registry.enablePigIronArmor, ModConfig.RegistryConfig.pig_iron){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            if (ModConfig.RegistryConfig.pig_iron.enableSetEffects && ArmorPlusItemUtils.isFullSet(player, APItems.pigIronHelmet, APItems.pigIronChestplate, APItems.pigIronLeggings, APItems.pigIronBoots)) {
                for (ItemStack e : player.func_184193_aE()) {
                    e.func_77972_a(1, (EntityLivingBase)player);
                }
            }
            this.addEffects(player, slot, APItems.pigIronHelmet, APItems.pigIronChestplate, APItems.pigIronLeggings, APItems.pigIronBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return Utils.getTCIngot(4);
        }
    }
    ,
    SLIME(ItemArmorBase.slimeArmor, ModConfig.RegistryConfig.global_registry.enableSlimeArmor, ModConfig.RegistryConfig.slime){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.slimeHelmet, APItems.slimeChestplate, APItems.slimeLeggings, APItems.slimeBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)Blocks.field_180399_cE);
        }
    }
    ,
    CHICKEN(ItemArmorBase.chickenArmor, ModConfig.RegistryConfig.global_registry.enableChickenArmor, ModConfig.RegistryConfig.chicken){

        @Override
        public void onArmorTick(EntityPlayer player, EntityEquipmentSlot slot) {
            this.addEffects(player, slot, APItems.chickenHelmet, APItems.chickenChestplate, APItems.chickenLeggings, APItems.chickenBoots);
        }

        @Override
        public ItemStack getRepairItem() {
            return ItemStackUtils.getItemStack((Object)Items.field_151008_G);
        }
    };

    private final ItemArmor.ArmorMaterial armorMaterial;
    private final boolean enableArmor;
    private final String formatting;
    private final boolean enableSetEffects;
    private final AbilityProvider applicableEffects;
    private final AbilityCanceller removableEffects;
    private final boolean isUnbreakable;
    private final boolean[] areEffectsEnabled;

    private APArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, boolean enableArmor, ModConfig.RegistryConfig.ArmorProperties armor) {
        this(armorMaterialIn, enableArmor, armor.itemNameColor, armor.enableSetEffects, armor.abilities, armor.enablePieceEffects, armor.removePotionEffects, armor.setUnbreakable);
    }

    private APArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, boolean enableArmor, String textFormattingIn, boolean enableSetEffects, Abilities effects, boolean[] areEffectsEnabledIn, String[] removeEffects, boolean isUnbreakable) {
        this.armorMaterial = armorMaterialIn;
        this.enableArmor = enableArmor;
        this.formatting = textFormattingIn;
        this.enableSetEffects = enableSetEffects;
        this.applicableEffects = new AbilityProvider(effects);
        this.areEffectsEnabled = areEffectsEnabledIn;
        this.removableEffects = new AbilityCanceller(removeEffects);
        this.isUnbreakable = isUnbreakable;
    }

    @Override
    public AbilityProvider getApplicableAbilities() {
        return this.applicableEffects;
    }

    @Override
    public AbilityCanceller getRemovableAbilities() {
        return this.removableEffects;
    }

    @Override
    public ItemStack getRepairStack() {
        return this.getRepairItem().func_190926_b() ? ItemStack.field_190927_a : this.getRepairItem();
    }

    public abstract ItemStack getRepairItem();

    @Override
    public boolean isEnabled() {
        return this.enableArmor;
    }

    public ItemArmor.ArmorMaterial getArmorMaterial() {
        return this.armorMaterial;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public TextFormatting getFormatting() {
        return TextFormatting.func_96300_b((String)this.formatting);
    }

    public boolean enableFullArmorEffect() {
        return this.enableSetEffects;
    }

    public boolean[] areEffectsEnabled() {
        return this.areEffectsEnabled;
    }

    public abstract void onArmorTick(EntityPlayer var1, EntityEquipmentSlot var2);

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (ToolTipUtils.isKeyDown()) {
            if (!this.enableFullArmorEffect()) {
                ToolTipUtils.addToolTipPiece(tooltip, this);
            } else {
                ToolTipUtils.addToolTipFull(tooltip, this);
            }
        } else {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, this.getFormatting());
        }
    }

    public void addEffects(EntityPlayer player, EntityEquipmentSlot slot, Item head, Item chestplate, Item legs, Item feet) {
        this.addPieceEffects(player, slot);
        this.addSetEffects(player, head, chestplate, legs, feet);
    }

    public void addPieceEffects(EntityPlayer player, EntityEquipmentSlot slot) {
        this.addEffects(player, slot == EntityEquipmentSlot.FEET ? 0 : (slot == EntityEquipmentSlot.LEGS ? 1 : (slot == EntityEquipmentSlot.CHEST ? 2 : (slot == EntityEquipmentSlot.HEAD ? 3 : -1))));
    }

    public void addEffects(EntityPlayer player, int index) {
        if (!this.enableFullArmorEffect() && this.areEffectsEnabled()[index]) {
            ArmorPlusItemUtils.applyEffects(player, this);
        }
    }

    public void addSetEffects(EntityPlayer player, Item head, Item chest, Item legs, Item feet) {
        if (this.enableFullArmorEffect() && ArmorPlusItemUtils.isFullSet(player, head, chest, legs, feet)) {
            ArmorPlusItemUtils.applyEffects(player, this);
        }
    }

    public boolean isUnbreakable() {
        return this.isUnbreakable;
    }
}

