/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.api.lavainfuser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.thedragonteam.armorplus.compat.crafttweaker.lavainfuser.LavaInfuserRecipe;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class LavaInfuserManager {
    private static final LavaInfuserManager INSTANCE = new LavaInfuserManager();
    private final Map<ItemStack, ItemStack> infusingList = Maps.newHashMap();
    private final Map<ItemStack, Double> experienceList = Maps.newHashMap();
    private final List<LavaInfuserRecipe> recipes = Lists.newArrayList();

    private LavaInfuserManager() {
        this.addInfusingRecipe(ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)0), ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1), 0.1);
        this.addInfusingRecipe(ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaCrystal), ItemStackUtils.getItemStack((Object)ModBlocks.blockInfusedLavaCrystal), 0.2);
        this.addInfusingRecipe(ModBlocks.blockCompressedObsidian, ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaInfusedObsidian), 0.2);
    }

    public static LavaInfuserManager getInstance() {
        return INSTANCE;
    }

    public void addInfusingRecipe(LavaInfuserRecipe recipe) {
        this.infusingList.put(recipe.input, recipe.output);
        this.experienceList.put(recipe.output, recipe.xp);
        this.recipes.add(recipe);
    }

    public void addInfusingRecipe(Object input, ItemStack stack, double experience) {
        if (input instanceof Block) {
            this.addInfusingRecipe(ItemStackUtils.getItemStack((Object)input), stack, experience);
        } else if (input instanceof Item) {
            this.addInfusingRecipe(ItemStackUtils.getItemStack((Object)input, (int)Short.MAX_VALUE), stack, experience);
        }
    }

    public void addInfusingRecipe(ItemStack input, ItemStack stack) {
        this.addInfusingRecipe(input, stack, 0.0);
    }

    public void addInfusingRecipe(ItemStack input, ItemStack stack, double experience) {
        if (!this.getInfusingResult(input).func_190926_b()) {
            LogHelper.info((Object)("Ignored infusing recipe with conflicting input: " + input + " = " + stack));
            return;
        }
        this.infusingList.put(input, stack);
        this.experienceList.put(stack, experience);
        this.recipes.add(new LavaInfuserRecipe(input, stack, experience));
    }

    public void removeFromRecipe(ItemStack recipe) {
        this.infusingList.remove(recipe);
    }

    public void removeRecipe(LavaInfuserRecipe recipe) {
        this.recipes.remove(recipe);
    }

    public ItemStack getInfusingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.infusingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return Optional.of(entry).map(Map.Entry::getValue).orElse(ItemStack.field_190927_a);
        }
        return Optional.empty().map(Map.Entry::getValue).orElse(ItemStack.field_190927_a);
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getInfusingList() {
        return this.infusingList;
    }

    public List<LavaInfuserRecipe> getRecipeList() {
        return this.recipes;
    }

    public double getInfusingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Double> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return Optional.of(entry).map(Map.Entry::getValue).orElse(0.0);
        }
        return Optional.empty().map(Map.Entry::getValue).orElse(0.0);
    }
}

