/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.api.crafting.base;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.thedragonteam.armorplus.api.crafting.IRecipe;
import net.thedragonteam.armorplus.api.crafting.IShapedRecipe;
import net.thedragonteam.armorplus.api.crafting.base.BaseShapedRecipe;
import net.thedragonteam.armorplus.api.crafting.utils.ShapedOreRecipeUtils;
import net.thedragonteam.armorplus.container.base.InventoryCraftingImproved;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public class BaseShapedOreRecipe
implements IRecipe,
IShapedRecipe {
    private int xy;
    protected ItemStack output;
    protected Object[] input;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = true;

    public BaseShapedOreRecipe(int xy, Block result, Object ... recipe) {
        this(xy, new ItemStack(result), recipe);
    }

    public BaseShapedOreRecipe(int xy, Item result, Object ... recipe) {
        this(xy, new ItemStack(result), recipe);
    }

    public BaseShapedOreRecipe(int xy, ItemStack result, Object ... recipe) {
        this.xy = xy;
        this.output = result.func_77946_l();
        StringBuilder shape = new StringBuilder();
        int index = 0;
        if (recipe[index] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[index];
            if (recipe[index + 1] instanceof Object[]) {
                recipe = (Object[])recipe[index + 1];
            } else {
                index = 1;
            }
        }
        if (recipe[index] instanceof String[]) {
            String[] parts = (String[])recipe[index++];
            Arrays.stream(parts).forEachOrdered(s -> {
                this.width = s.length();
                shape.append((String)s);
            });
            this.height = parts.length;
        } else {
            while (recipe[index] instanceof String) {
                String s2 = (String)recipe[index++];
                shape.append(s2);
                this.width = s2.length();
                ++this.height;
            }
        }
        ShapedOreRecipeUtils.checkRecipeShape(this.width, this.height, shape, this.output, recipe);
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (index < recipe.length) {
            Character chr = (Character)recipe[index];
            Object in = recipe[index + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, ItemStackUtils.getItemStack((Object)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, ItemStackUtils.getItemStack((Object)in, (int)1, (int)Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else {
                StringBuilder ret = new StringBuilder("Invalid shaped ore recipe: ");
                Arrays.stream(recipe).forEachOrdered(tmp -> ret.append(tmp).append(", "));
                ret.append(this.output);
                throw new RuntimeException(ret.toString());
            }
            index += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toString().toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    BaseShapedOreRecipe(BaseShapedRecipe recipe, Map<ItemStack, String> replacements) {
        this.output = recipe.getRecipeOutput();
        this.width = recipe.recipeWidth;
        this.height = recipe.recipeHeight;
        this.input = new Object[recipe.getInput().size()];
        block0: for (int i = 0; i < this.input.length; ++i) {
            ItemStack ingredient = (ItemStack)recipe.getInput().get(i);
            if (ingredient.func_190926_b()) continue;
            this.input[i] = recipe.getInput().get(i);
            for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingredient, (boolean)true)) continue;
                this.input[i] = OreDictionary.getOres((String)replace.getValue());
                continue block0;
            }
        }
    }

    @Override
    @Nonnull
    public ItemStack getCraftingResult(@Nonnull InventoryCraftingImproved var1) {
        return this.output.func_77946_l();
    }

    @Override
    public int getRecipeSize() {
        return this.input.length;
    }

    @Override
    @Nonnull
    public ItemStack getRecipeOutput() {
        return this.output;
    }

    @Override
    public boolean matches(@Nonnull InventoryCraftingImproved inv, @Nonnull World world) {
        return ShapedOreRecipeUtils.matches(this.width, this.height, this.input, inv);
    }

    public BaseShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }

    @Override
    public int getRecipeWidth() {
        return this.xy;
    }

    @Override
    public int getRecipeHeight() {
        return this.xy;
    }
}

