/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.api.crafting.base;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.thedragonteam.armorplus.api.crafting.IRecipe;
import net.thedragonteam.armorplus.api.crafting.base.BaseShapedRecipe;
import net.thedragonteam.armorplus.api.crafting.base.BaseShapelessRecipe;
import net.thedragonteam.armorplus.api.crafting.hightechbench.recipes.ModHighTechItemRecipes;
import net.thedragonteam.armorplus.api.crafting.hightechbench.recipes.ModTierTwoRecipes;
import net.thedragonteam.armorplus.api.crafting.hightechbench.recipes.ModTinkersConstructRecipes;
import net.thedragonteam.armorplus.api.crafting.hightechbench.recipes.ModWeaponTierTwoRecipes;
import net.thedragonteam.armorplus.api.crafting.ultitechbench.recipes.ModEnderDragonRecipes;
import net.thedragonteam.armorplus.api.crafting.ultitechbench.recipes.ModGuardianRecipes;
import net.thedragonteam.armorplus.api.crafting.ultitechbench.recipes.ModSuperStarRecipes;
import net.thedragonteam.armorplus.api.crafting.ultitechbench.recipes.ModUltiTechItemRecipes;
import net.thedragonteam.armorplus.api.crafting.ultitechbench.recipes.ModUltimateRecipes;
import net.thedragonteam.armorplus.api.crafting.ultitechbench.recipes.ModWeaponTierThreeRecipes;
import net.thedragonteam.armorplus.api.crafting.utils.CraftingUtils;
import net.thedragonteam.armorplus.api.crafting.workbench.recipes.ModItemRecipes;
import net.thedragonteam.armorplus.api.crafting.workbench.recipes.ModOriginRecipes;
import net.thedragonteam.armorplus.api.crafting.workbench.recipes.ModSpecialMobRecipes;
import net.thedragonteam.armorplus.api.crafting.workbench.recipes.ModWeaponsTierOneRecipes;
import net.thedragonteam.armorplus.container.base.InventoryCraftingImproved;

public class BaseCraftingManager {
    private static final BaseCraftingManager CHAMPION_BENCH = new BaseCraftingManager(9, "Champion Bench");
    private static final BaseCraftingManager ULTI_TECH_BENCH = new BaseCraftingManager(7, "Ulti-Tech Bench"){
        {
            new ModUltimateRecipes().addRecipes(this);
            new ModEnderDragonRecipes().addRecipes(this);
            new ModSuperStarRecipes().addRecipes(this);
            new ModGuardianRecipes().addRecipes(this);
            new ModWeaponTierThreeRecipes().addRecipes(this);
            new ModUltiTechItemRecipes().addRecipes(this);
        }
    };
    private static final BaseCraftingManager HIGH_TECH_BENCH = new BaseCraftingManager(5, "High-Tech Bench"){
        {
            new ModTierTwoRecipes().addRecipes(this);
            new ModHighTechItemRecipes().addRecipes(this);
            new ModWeaponTierTwoRecipes().addRecipes(this);
            new ModTinkersConstructRecipes().addRecipes(this);
        }
    };
    private static final BaseCraftingManager WORKBENCH = new BaseCraftingManager(3, "Workbench"){
        {
            new ModItemRecipes().addRecipes(this);
            new ModOriginRecipes().addRecipes(this);
            new ModSpecialMobRecipes().addRecipes(this);
            new ModWeaponsTierOneRecipes().addRecipes(this);
        }
    };
    private final List<IRecipe> recipes = Lists.newArrayList();
    private int xy;
    private String name;

    public static BaseCraftingManager getCBInstance() {
        return CHAMPION_BENCH;
    }

    public static BaseCraftingManager getUTBInstance() {
        return ULTI_TECH_BENCH;
    }

    public static BaseCraftingManager getHTBInstance() {
        return HIGH_TECH_BENCH;
    }

    public static BaseCraftingManager getWBInstance() {
        return WORKBENCH;
    }

    public BaseCraftingManager(int xy, String name) {
        this.xy = xy;
        this.name = name;
        this.recipes.sort((pCompare1, pCompare2) -> Integer.compare(pCompare2.getRecipeSize(), pCompare1.getRecipeSize()));
    }

    public BaseShapedRecipe addRecipe(ItemStack stack, Object ... recipeComponents) {
        Object components;
        StringBuilder shape = new StringBuilder();
        int index = 0;
        int width = 0;
        int height = 0;
        if (recipeComponents[index] instanceof String[]) {
            components = (String[])recipeComponents[index++];
            for (String component : components) {
                ++height;
                width = component.length();
                shape.append(component);
            }
        } else {
            while (recipeComponents[index] instanceof String) {
                components = (String)recipeComponents[index++];
                ++height;
                width = ((String)components).length();
                shape.append((String)components);
            }
        }
        Map<Character, ItemStack> map = CraftingUtils.getCharacterItemStackMap(index, recipeComponents);
        NonNullList recipeShape = NonNullList.func_191197_a((int)(width * height), (Object)ItemStack.field_190927_a);
        IntStream.range(0, width * height).forEachOrdered(l -> {
            char c0 = shape.charAt(l);
            recipeShape.set(l, (Object)(map.containsKey(Character.valueOf(c0)) ? ((ItemStack)map.get(Character.valueOf(c0))).func_77946_l() : ItemStack.field_190927_a));
        });
        BaseShapedRecipe shapedrecipes = new BaseShapedRecipe(this.xy, width, height, (NonNullList<ItemStack>)recipeShape, stack);
        this.recipes.add(shapedrecipes);
        return shapedrecipes;
    }

    public String getName() {
        return this.name;
    }

    public void addShapelessRecipe(ItemStack stack, Object ... recipeComponents) {
        NonNullList list = NonNullList.func_191196_a();
        CraftingUtils.addShapelessRecipe((NonNullList<ItemStack>)list, recipeComponents);
        this.recipes.add(new BaseShapelessRecipe(stack, (NonNullList<ItemStack>)list));
    }

    public void addRecipe(IRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void addRecipes(IRecipe ... recipes) {
        Arrays.stream(recipes).forEach(this::addRecipe);
    }

    public void removeRecipe(IRecipe recipe) {
        this.recipes.remove(recipe);
    }

    public ItemStack findMatchingRecipe(InventoryCraftingImproved craftMatrix, World worldIn) {
        return CraftingUtils.findMatchingRecipe(this.recipes, craftMatrix, worldIn);
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCraftingImproved craftMatrix, World worldIn) {
        return CraftingUtils.getRemainingItems(this.recipes, craftMatrix, worldIn);
    }

    public List<IRecipe> getRecipeList() {
        return this.recipes;
    }
}

