/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.network.response;

import io.netty.buffer.ByteBuf;
import net.dries007.holoInventory.Helper;
import net.dries007.holoInventory.client.ClientEventHandler;
import net.dries007.holoInventory.client.renderers.IRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class ResponseMessage
implements IMessage {
    private Helper.Type type;
    private int id;
    private BlockPos pos;

    public ResponseMessage() {
    }

    public ResponseMessage(int id) {
        this.type = Helper.Type.ENTITY;
        this.id = id;
    }

    public ResponseMessage(BlockPos pos) {
        this.type = Helper.Type.TILE;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Helper.Type.values()[buf.readByte()];
        switch (this.type) {
            case TILE: {
                this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
                break;
            }
            case ENTITY: {
                this.id = buf.readInt();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        switch (this.type) {
            case TILE: {
                buf.writeInt(this.pos.func_177958_n());
                buf.writeInt(this.pos.func_177956_o());
                buf.writeInt(this.pos.func_177952_p());
                break;
            }
            case ENTITY: {
                buf.writeInt(this.id);
            }
        }
    }

    public final Helper.Type getType() {
        return this.type;
    }

    public final BlockPos getPos() {
        return this.pos;
    }

    public final int getId() {
        return this.id;
    }

    public static void handle(ResponseMessage message, IRenderer renderer) {
        switch (message.getType()) {
            case TILE: {
                ClientEventHandler.cache(message.getPos(), renderer);
                break;
            }
            case ENTITY: {
                ClientEventHandler.cache(message.getId(), renderer);
            }
        }
    }
}

