/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.client.renderers;

import java.util.ArrayList;
import java.util.List;
import net.dries007.holoInventory.client.renderers.IRenderer;
import net.dries007.holoInventory.client.renderers.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class InventoryRenderer
implements IRenderer {
    private final String name;
    private final List<ItemStack> stacks;

    public InventoryRenderer(String name, List<ItemStack> input) {
        String name2;
        String tmp = I18n.func_135052_a((String)name, (Object[])new Object[0]);
        this.name = !tmp.equals(name) ? tmp : (!(tmp = I18n.func_135052_a((String)(name2 = name + ".name"), (Object[])new Object[0])).equals(name2) ? tmp : name);
        this.stacks = new ArrayList<ItemStack>(input.size());
        block0: for (ItemStack stack : input) {
            if (stack == null) continue;
            for (ItemStack stack2 : this.stacks) {
                if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stack2) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stack2)) continue;
                stack2.func_190917_f(stack.func_190916_E());
                continue block0;
            }
            this.stacks.add(stack);
        }
    }

    @Override
    public void render(WorldClient world, RayTraceResult hit, Vec3d pos) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager rm = mc.func_175598_ae();
        RenderItem ri = mc.func_175599_af();
        GlStateManager.func_179137_b((double)(pos.field_72450_a - TileEntityRendererDispatcher.field_147554_b), (double)(pos.field_72448_b - TileEntityRendererDispatcher.field_147555_c), (double)(pos.field_72449_c - TileEntityRendererDispatcher.field_147552_d));
        GlStateManager.func_179114_b((float)(-rm.field_78735_i), (float)0.0f, (float)0.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)rm.field_78732_j, (float)0.5f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.5);
        double d = pos.func_72438_d(new Vec3d(TileEntityRendererDispatcher.field_147554_b, TileEntityRendererDispatcher.field_147555_c, TileEntityRendererDispatcher.field_147552_d));
        if (d < 1.75) {
            return;
        }
        GlStateManager.func_179139_a((double)(d * 0.2), (double)(d * 0.2), (double)(d * 0.2));
        int cols = this.stacks.size() <= 9 ? this.stacks.size() : (this.stacks.size() <= 27 ? 9 : (this.stacks.size() <= 54 ? 11 : (this.stacks.size() <= 90 ? 14 : (this.stacks.size() <= 109 ? 18 : 21))));
        int rows = 1 + (this.stacks.size() % cols == 0 ? this.stacks.size() / cols - 1 : this.stacks.size() / cols);
        if (rows > 4) {
            GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)((double)-0.6f - (double)0.4f * ((double)rows / 2.0)), (double)0.0);
        GlStateManager.func_179139_a((double)0.03, (double)0.03, (double)0.03);
        int w = mc.field_71466_p.func_78256_a(this.name);
        GlStateManager.func_179097_i();
        mc.field_71466_p.func_78276_b(this.name, -w / 2, 0, 0xFFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        int r = 0;
        int c = 0;
        for (ItemStack stack : this.stacks) {
            RenderHelper.renderStack(ri, stack, cols, c, rows, r);
            if (++c != cols) continue;
            ++r;
            c = 0;
        }
        r = 0;
        c = 0;
        GlStateManager.func_179097_i();
        for (ItemStack stack : this.stacks) {
            RenderHelper.renderName(mc.field_71466_p, stack, cols, c, rows, r, -1);
            if (++c != cols) continue;
            ++r;
            c = 0;
        }
        GlStateManager.func_179126_j();
    }

    @Override
    public boolean shouldRender() {
        return this.stacks.size() != 0;
    }
}

