/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowlib.version;

import net.shadowfacts.shadowlib.version.InvalidVersionException;
import net.shadowfacts.shadowlib.version.Version;

public class VersionMatcher {
    private static final String[] WILDCARD_STRINGS = new String[]{"*", "x", "X"};
    private String matcherString;

    public VersionMatcher(String matcherString) {
        this.matcherString = matcherString;
    }

    public boolean matches(Version v) {
        return VersionMatcher.matches(this.matcherString, v);
    }

    public static boolean matches(String matcherString, Version v) {
        for (String s : WILDCARD_STRINGS) {
            if (!matcherString.equals(s)) continue;
            return true;
        }
        if (matcherString.startsWith(">=")) {
            return VersionMatcher.matchesGreaterThanOrEqualTo(matcherString.substring(2), v);
        }
        if (matcherString.startsWith("<=")) {
            return VersionMatcher.matchesLessThanOrEqualTo(matcherString.substring(2), v);
        }
        if (matcherString.startsWith("^") || matcherString.startsWith(">")) {
            return VersionMatcher.matchesGreaterThan(matcherString.substring(1), v);
        }
        if (matcherString.startsWith("<")) {
            return VersionMatcher.matchesLessThan(matcherString.substring(1), v);
        }
        boolean majorValid = false;
        boolean minorValid = false;
        boolean patchValid = false;
        boolean labelValid = false;
        String label = "";
        String[] arr = matcherString.split("\\-");
        String[] arr2 = arr[0].split("\\.");
        if (arr2.length != 3) {
            throw new InvalidVersionException("Cannot create Version with %d version arguments", arr2.length);
        }
        String major = arr2[0];
        String minor = arr2[1];
        String patch = arr2[2];
        if (arr.length == 2) {
            if (arr[1] == null) {
                throw new InvalidVersionException("Cannot create Version with null label");
            }
            if (arr[1].equals("")) {
                throw new InvalidVersionException("Cannot create Version with empty label");
            }
            label = arr[1];
        } else if (arr.length > 2) {
            for (int i = 1; i < arr.length - 1; ++i) {
                if (arr[i] == null) {
                    throw new InvalidVersionException("Cannot create Version with null label");
                }
                if (arr[i].equals("")) {
                    throw new InvalidVersionException("Cannot create Version with empty label");
                }
                label = label + arr[i];
            }
        }
        for (String s : WILDCARD_STRINGS) {
            if (!majorValid) {
                majorValid = major.equals(s);
            }
            if (!minorValid) {
                minorValid = minor.equals(s);
            }
            if (patchValid) continue;
            patchValid = patch.equals(s);
        }
        if (!majorValid) {
            boolean bl = majorValid = Integer.parseInt(major) == v.getMajor();
        }
        if (!minorValid) {
            boolean bl = minorValid = Integer.parseInt(minor) == v.getMinor();
        }
        if (!patchValid) {
            patchValid = Integer.parseInt(patch) == v.getPatch();
        }
        boolean bl = labelValid = !v.hasLabel() && label.isEmpty();
        if (!labelValid) {
            labelValid = label.equals(v.getLabel());
        }
        return majorValid && minorValid && patchValid && labelValid;
    }

    private static boolean matchesGreaterThan(String s, Version v) {
        return v.greaterThan(new Version(s));
    }

    private static boolean matchesLessThan(String s, Version v) {
        return v.lessThan(new Version(s));
    }

    private static boolean matchesGreaterThanOrEqualTo(String s, Version v) {
        Version other = new Version(s);
        return v.equals(other) || v.greaterThan(other);
    }

    private static boolean matchesLessThanOrEqualTo(String s, Version v) {
        Version other = new Version(s);
        return v.equals(other) || v.lessThan(other);
    }
}

