/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowlib.util;

import java.io.File;
import java.util.function.Consumer;

public class FileUtils {
    public static void forEachInDirectory(File dir, Consumer<File> consumer) {
        File[] dirListing = dir.listFiles();
        if (dirListing != null) {
            for (File f : dirListing) {
                consumer.accept(f);
            }
        } else {
            throw new NullPointerException("dirListing was null");
        }
    }

    public static void deleteDirRecursive(File dir) {
        FileUtils.deleteDirContentsRecursive(dir);
        dir.delete();
    }

    public static void deleteDirContentsRecursive(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileUtils.deleteDirRecursive(f);
                    continue;
                }
                f.delete();
            }
        }
    }

    public static Boolean checkCreateDir(File dir) {
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return null;
    }

    public static void checkCreateDirs(File ... dirs) {
        for (File dir : dirs) {
            if (dir.exists()) continue;
            dir.mkdirs();
        }
    }
}

