/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.mirror.stream;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.shadowfacts.mirror.MirrorField;

public class FieldStream
implements Stream<MirrorField> {
    private Stream<MirrorField> underlying;

    public FieldStream(Stream<MirrorField> underlying) {
        this.underlying = underlying;
    }

    public Stream<Field> unwrap() {
        return this.map((Function)MirrorField::unwrap);
    }

    public FieldStream filterDeclaringClass(Class<?> ... classes) {
        return this.filter((T f) -> {
            Class<?> declaringClass = f.declaringClass().unwrap();
            for (Class c : classes) {
                if (declaringClass != c) continue;
                return true;
            }
            return false;
        });
    }

    public Stream<Object> get(Object instance) {
        return this.map((Function)f -> f.get(instance));
    }

    public Object[] getToArray(Object instance) {
        return this.get(instance).toArray();
    }

    public void set(Object instance, Object value) {
        this.forEach((Consumer<? super MirrorField>)((Consumer<MirrorField>)f -> f.set(instance, value)));
    }

    public FieldStream hasAnnotation(Class<? extends Annotation> clazz) {
        return this.filter((T f) -> f.hasAnnotation(clazz));
    }

    public <A extends Annotation> Stream<A> getAnnotation(Class<A> clazz) {
        return this.map((Function)f -> f.getAnnotation(clazz));
    }

    public FieldStream isStatic() {
        return this.filter(MirrorField::isStatic);
    }

    public FieldStream isNotStatic() {
        return this.filter(MirrorField::isNotStatic);
    }

    public FieldStream isFinal() {
        return this.filter(MirrorField::isFinal);
    }

    public FieldStream isNotFinal() {
        return this.filter(MirrorField::isNotFinal);
    }

    public FieldStream isPublic() {
        return this.filter(MirrorField::isPublic);
    }

    public FieldStream isProtected() {
        return this.filter(MirrorField::isProtected);
    }

    public FieldStream isPrivate() {
        return this.filter(MirrorField::isPrivate);
    }

    public FieldStream hasModifier(int modifier) {
        return this.filter((T f) -> f.hasModifier(modifier));
    }

    public FieldStream setAccessible(boolean accessible) {
        return this.peek((T f) -> f.setAccessible(accessible));
    }

    public FieldStream filter(Predicate<? super MirrorField> predicate) {
        return new FieldStream(this.underlying.filter(predicate));
    }

    @Override
    public <R> Stream<R> map(Function<? super MirrorField, ? extends R> mapper) {
        return this.underlying.map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super MirrorField> mapper) {
        return this.underlying.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super MirrorField> mapper) {
        return this.underlying.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super MirrorField> mapper) {
        return this.underlying.mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super MirrorField, ? extends Stream<? extends R>> mapper) {
        return this.underlying.flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super MirrorField, ? extends IntStream> mapper) {
        return this.underlying.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super MirrorField, ? extends LongStream> mapper) {
        return this.underlying.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super MirrorField, ? extends DoubleStream> mapper) {
        return this.underlying.flatMapToDouble(mapper);
    }

    public FieldStream distinct() {
        return new FieldStream(this.underlying.distinct());
    }

    public FieldStream sorted() {
        return new FieldStream(this.underlying.sorted());
    }

    public FieldStream sorted(Comparator<? super MirrorField> comparator) {
        return new FieldStream(this.underlying.sorted(comparator));
    }

    public FieldStream peek(Consumer<? super MirrorField> action) {
        return new FieldStream(this.underlying.peek(action));
    }

    public FieldStream limit(long maxSize) {
        return new FieldStream(this.underlying.limit(maxSize));
    }

    public FieldStream skip(long n) {
        return new FieldStream(this.underlying.skip(n));
    }

    @Override
    public void forEach(Consumer<? super MirrorField> action) {
        this.underlying.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super MirrorField> action) {
        this.underlying.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.underlying.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.underlying.toArray(generator);
    }

    @Override
    public MirrorField reduce(MirrorField identity, BinaryOperator<MirrorField> accumulator) {
        return this.underlying.reduce(identity, accumulator);
    }

    @Override
    public Optional<MirrorField> reduce(BinaryOperator<MirrorField> accumulator) {
        return this.underlying.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super MirrorField, U> accumulator, BinaryOperator<U> combiner) {
        return this.underlying.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super MirrorField> accumulator, BiConsumer<R, R> combiner) {
        return this.underlying.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super MirrorField, A, R> collector) {
        return this.underlying.collect(collector);
    }

    @Override
    public Optional<MirrorField> min(Comparator<? super MirrorField> comparator) {
        return this.underlying.min(comparator);
    }

    @Override
    public Optional<MirrorField> max(Comparator<? super MirrorField> comparator) {
        return this.underlying.max(comparator);
    }

    @Override
    public long count() {
        return this.underlying.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super MirrorField> predicate) {
        return this.underlying.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super MirrorField> predicate) {
        return this.underlying.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super MirrorField> predicate) {
        return this.underlying.noneMatch(predicate);
    }

    @Override
    public Optional<MirrorField> findFirst() {
        return this.underlying.findFirst();
    }

    @Override
    public Optional<MirrorField> findAny() {
        return this.underlying.findAny();
    }

    @Override
    public Iterator<MirrorField> iterator() {
        return this.underlying.iterator();
    }

    @Override
    public Spliterator<MirrorField> spliterator() {
        return this.underlying.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.underlying.isParallel();
    }

    @Override
    public FieldStream sequential() {
        return new FieldStream((Stream)this.underlying.sequential());
    }

    @Override
    public FieldStream parallel() {
        return new FieldStream((Stream)this.underlying.parallel());
    }

    @Override
    public FieldStream unordered() {
        return new FieldStream((Stream)this.underlying.unordered());
    }

    @Override
    public FieldStream onClose(Runnable closeHandler) {
        this.underlying.onClose(closeHandler);
        return this;
    }

    @Override
    public void close() {
        this.underlying.close();
    }
}

