/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.tile;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import reborncore.api.IToolDrop;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TileEnergyBase;

public abstract class TileMachineBase
extends TileEnergyBase
implements IToolDrop {
    private int costPerTick;
    private int ticksNeeded;
    public int progress;

    public TileMachineBase(EnumPowerTier tier, int capacity, int costPerTick, int ticksNeeded) {
        super(tier, capacity);
        this.costPerTick = costPerTick;
        this.ticksNeeded = ticksNeeded;
    }

    public boolean canWork() {
        return this.getEnergy() >= (double)this.costPerTick;
    }

    public void updateCostAndDuration(int costPerTick, int ticksNeeded) {
        this.costPerTick = costPerTick == -1 ? this.costPerTick : costPerTick;
        this.ticksNeeded = ticksNeeded == -1 ? this.ticksNeeded : ticksNeeded;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this instanceof IRecipeCrafterProvider) {
            IRecipeCrafterProvider provider = (IRecipeCrafterProvider)((Object)this);
            provider.getRecipeCrafter().updateEntity();
        }
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.ticksNeeded;
    }

    @Override
    public int getEnergyScaled(int scale) {
        return (int)(this.getEnergy() * (double)scale / this.getMaxPower());
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public void setFacing(EnumFacing enumFacing) {
        Block block = this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c();
        if (block instanceof BlockMachineBase) {
            ((BlockMachineBase)block).setFacing(enumFacing, this.func_145831_w(), this.func_174877_v());
        }
    }

    public void func_189667_a(Rotation rotationIn) {
        this.setFacing(rotationIn.func_185831_a(this.getFacing()));
    }

    @Override
    public abstract ItemStack getToolDrop(EntityPlayer var1);

    @Override
    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    @Override
    public double getMaxOutput() {
        return 0.0;
    }

    @Override
    public double getMaxInput() {
        return 0.0;
    }
}

