/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import io.netty.buffer.ByteBuf;
import journeymap.common.Journeymap;
import journeymap.common.network.model.Location;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TeleportPacket
implements IMessage {
    public static final String CHANNEL_NAME = "jtp";
    private String location;

    public TeleportPacket() {
    }

    public TeleportPacket(Location location) {
        this.location = Location.GSON.toJson((Object)location);
    }

    public String getLocation() {
        return this.location;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.location = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message: %s", t));
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            if (this.location != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.location);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message: " + t);
        }
    }

    public static class Listener
    implements IMessageHandler<TeleportPacket, IMessage> {
        public IMessage onMessage(TeleportPacket message, MessageContext ctx) {
            EntityPlayerMP player = null;
            player = ctx.getServerHandler().field_147369_b;
            Location location = (Location)Location.GSON.fromJson(message.getLocation(), Location.class);
            return null;
        }
    }
}

