/*
 * Decompiled with CFR 0.152.
 */
package tschipp.tschipplib.helper;

import java.awt.Color;
import net.minecraft.util.math.MathHelper;

public class ColorHelper {
    public static float[] getRGB(Color color) {
        if (color == null) {
            return null;
        }
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        return new float[]{r, g, b};
    }

    public static float[] getRGB(int ... color) {
        if (color == null || color.length < 3) {
            return null;
        }
        float r = (float)color[0] / 255.0f;
        float g = (float)color[1] / 255.0f;
        float b = (float)color[2] / 255.0f;
        return new float[]{r, g, b};
    }

    public static float[] brighter(float amount, float ... rgb) {
        if (rgb.length < 3) {
            return null;
        }
        int r = (int)(rgb[0] * 255.0f);
        int g = (int)(rgb[1] * 255.0f);
        int b = (int)(rgb[2] * 255.0f);
        float[] hsb = Color.RGBtoHSB(r, g, b, new float[3]);
        hsb[1] = hsb[1] + amount;
        hsb = ColorHelper.clampColor(hsb);
        Color col = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return ColorHelper.getRGB(col);
    }

    public static float[] darker(float amount, float ... rgb) {
        if (rgb.length < 3) {
            return null;
        }
        int r = (int)(rgb[0] * 255.0f);
        int g = (int)(rgb[1] * 255.0f);
        int b = (int)(rgb[2] * 255.0f);
        float[] hsb = Color.RGBtoHSB(r, g, b, new float[3]);
        hsb[2] = hsb[2] - amount;
        hsb = ColorHelper.clampColor(hsb);
        Color col = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return ColorHelper.getRGB(col);
    }

    public static float[] changeBrightness(float amount, float ... rgb) {
        if (amount < 0.0f) {
            return ColorHelper.darker(Math.abs(amount), rgb);
        }
        return ColorHelper.brighter(amount, rgb);
    }

    private static float[] clampColor(float[] col) {
        col[0] = MathHelper.func_76131_a((float)col[0], (float)0.0f, (float)1.0f);
        col[1] = MathHelper.func_76131_a((float)col[1], (float)0.0f, (float)1.0f);
        col[2] = MathHelper.func_76131_a((float)col[2], (float)0.0f, (float)1.0f);
        return col;
    }
}

