/*
 * Decompiled with CFR 0.152.
 */
package tschipp.tschipplib.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import tschipp.tschipplib.gui.IProgressable;

public class ProgressDisplay
extends Gui {
    private IProgressable progressable;
    private int xWidth;
    private int yWidth;
    private ResourceLocation texture;
    private int textX;
    private int textY;
    private int drawX;
    private int drawY;
    private int barWidth;
    private int barHeight;
    private boolean sideways;

    public ProgressDisplay(IProgressable progressable, int xWidth, int yWidth, ResourceLocation texture, int textX, int textY, int drawX, int drawY, int barWidth, int barHeight, boolean sideways) {
        this.xWidth = xWidth;
        this.yWidth = yWidth;
        this.textX = textX;
        this.textY = textY;
        this.texture = texture;
        this.progressable = progressable;
        this.drawX = drawX;
        this.drawY = drawY;
        this.barWidth = barWidth;
        this.barHeight = barHeight;
        this.sideways = sideways;
    }

    public void drawDisplay() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(this.texture);
        int progress = this.progressable.getProgress();
        int max = this.progressable.getMaxProgress();
        float p = (float)progress / (float)max;
        if (this.sideways) {
            this.func_73729_b(this.xWidth + this.drawX, this.yWidth + this.drawY - 1, this.textX, this.textY, (int)((float)this.barWidth * p), this.barHeight);
        } else {
            this.func_73729_b(this.xWidth + this.drawX, this.yWidth + this.drawY - 1, this.textX, this.textY, this.barWidth, (int)((float)this.barHeight * p));
        }
    }

    public void drawOverlay(int x, int y) {
        if (x >= this.xWidth + this.drawX && x <= this.xWidth + this.drawX + this.barWidth && y >= this.yWidth + this.drawY && y <= this.yWidth + this.drawY + this.barHeight) {
            int progress = this.progressable.getProgress();
            int max = this.progressable.getMaxProgress();
            float p = (float)progress / (float)max;
            ArrayList<String> text = new ArrayList<String>();
            text.add((int)(p * 100.0f) + "%");
            GuiUtils.drawHoveringText(text, (int)x, (int)y, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
    }
}

